/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.config.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.configuration.builder.CoreConfigBuilder;
import org.eclipse.alf.security.sso.common.http.configuration.builder.PKIConfigBuilder;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.URIMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.builder.URIMatcherBuilder;
import org.eclipse.alf.security.sso.common.util.FileIOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.config.builder.GatekeeperServiceConfigBuilder;

public class GatekeeperConfigBuilder {
    private static final Logger log = Logger.getLogger(GatekeeperConfigBuilder.class);
    public static final String SERVICES_CONFIG_LN = "GatekeeperConfig";
    public static final String GATEKEEPER_PROTECTION_CONTROL_LN = "GatekeeperProtectionControl";
    public static final String NON_PROTECTED_URIS_LN = "NonProtectedURIs";
    public static final String PROTECTED_URIS_LN = "ProtectedURIs";
    public static final String GLOBAL_CORE_CONFIG_LN = "GlobalCoreConfig";
    public static final String PKI_CONFIG_LN = "PKIConfig";
    public static final String ATTR_FILE = "file";
    protected String basePath;

    public GatekeeperConfigBuilder() {
    }

    public GatekeeperConfigBuilder(String basePath) {
        this.basePath = basePath;
    }

    public GatekeeperConfig build(String basePath, String configFile) throws SSOException {
        return this.build(basePath, configFile, null);
    }

    public GatekeeperConfig build(String basePath, String configFile, GatekeeperConfig base) throws SSOException {
        this.basePath = basePath;
        return this.build(basePath + configFile, base);
    }

    public GatekeeperConfig build(String configFile) throws SSOException {
        return this.build(configFile, (GatekeeperConfig)null);
    }

    public GatekeeperConfig build(String configFile, GatekeeperConfig base) throws SSOException {
        InputStream is;
        File f = new File(configFile);
        if (StringHelper.isBlank((String)this.basePath) && f.isFile()) {
            this.basePath = FileIOHelper.normalizePath((String)(f.getAbsoluteFile().getParent() + "/"));
        }
        if ((is = FileIOHelper.loadResource((String)this.basePath, (String)configFile)) == null) {
            String errMsg = "Error loading validation policy from \"" + configFile + "\": file not found";
            log.error((Object)errMsg);
            return null;
        }
        GatekeeperConfig retVal = this.build(is, base);
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                log.error((Object)"Error closing input stream");
            }
        }
        return retVal;
    }

    public GatekeeperConfig build(InputStream instream) throws SSOException {
        return this.build(instream, null);
    }

    public GatekeeperConfig build(InputStream instream, GatekeeperConfig base) throws SSOException {
        StAXOMBuilder builder = null;
        OMElement el = null;
        try {
            builder = new StAXOMBuilder(instream);
            el = builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            String errMsg = "Error loading validation policy from stream";
            log.error((Object)errMsg);
            throw new SSOException(errMsg, (Throwable)e);
        }
        return this.build(el, base);
    }

    public GatekeeperConfig build(OMElement element) throws SSOException {
        return this.build(element, null);
    }

    public GatekeeperConfig build(OMElement element, GatekeeperConfig base) throws SSOException {
        if (element == null) {
            log.warn((Object)"ServicesConfigBuilder.build(null) called");
            return null;
        }
        OMElement el = null;
        el = element.getLocalName().equals(SERVICES_CONFIG_LN) ? element : element.getFirstChildWithName(new QName(SERVICES_CONFIG_LN));
        if (el == null) {
            log.error((Object)"ServicesConfigBuilder.build(): services config element cannot be found");
            return null;
        }
        GatekeeperConfig gatekeeperConfig = null;
        gatekeeperConfig = base != null ? base : new GatekeeperConfig();
        int serviceConfigSuccess = 0;
        int serviceConfigFailed = 0;
        GatekeeperServiceConfigBuilder serviceConfigBuilder = new GatekeeperServiceConfigBuilder();
        serviceConfigBuilder.setBasePath(this.basePath);
        OMElement globalCoreConfigEl = el.getFirstChildWithName(new QName(GLOBAL_CORE_CONFIG_LN));
        String configFile = XMLHelper.getAttribute((OMElement)globalCoreConfigEl, (String)ATTR_FILE);
        if (globalCoreConfigEl != null) {
            CoreConfig globalCoreConfig = null;
            CoreConfigBuilder globalCoreConfigBuilder = new CoreConfigBuilder(this.basePath);
            globalCoreConfigBuilder.setInitializeCookieManager(false);
            globalCoreConfigBuilder.setInstantiateRemoteDataClient(true);
            globalCoreConfigBuilder.setLoadKeystores(true);
            globalCoreConfigBuilder.setValidateLocalName(false);
            if (StringHelper.isNotBlank((String)configFile)) {
                InputStream is = FileIOHelper.loadResource((String)this.basePath, (String)configFile);
                if (is != null) {
                    globalCoreConfig = globalCoreConfigBuilder.build(is, null);
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing input stream");
                    }
                    if (globalCoreConfig == null) {
                        log.error((Object)"Failed to load core configuration");
                    }
                } else {
                    log.error((Object)("Failed to load CoreConfig from \"" + configFile + "\" (basePath=\"" + this.basePath + "\""));
                }
            }
            globalCoreConfig = globalCoreConfigBuilder.build(globalCoreConfigEl, globalCoreConfig);
            gatekeeperConfig.setGlobalCoreConfig(globalCoreConfig);
            serviceConfigBuilder.setDefaultCoreConfig(globalCoreConfig);
        } else {
            log.warn((Object)"<GlobalCoreConfig> element is missing. Assuming defaults.");
            gatekeeperConfig.setGlobalCoreConfig(new CoreConfig());
        }
        OMElement gatekeeperProtectionControlEl = el.getFirstChildWithName(new QName(GATEKEEPER_PROTECTION_CONTROL_LN));
        if (gatekeeperProtectionControlEl != null) {
            OMElement nonProtectedURIsEl;
            OMElement protectedURIsEl = gatekeeperProtectionControlEl.getFirstChildWithName(new QName(PROTECTED_URIS_LN));
            if (protectedURIsEl != null) {
                Iterator uriMatcherIt = protectedURIsEl.getChildrenWithName(new QName("URIMatcher"));
                URIMatcherBuilder uriMatcherBuilder = new URIMatcherBuilder();
                while (uriMatcherIt != null && uriMatcherIt.hasNext()) {
                    OMElement uriMatcherEl = (OMElement)uriMatcherIt.next();
                    URIMatcher uriMatcher = (URIMatcher)uriMatcherBuilder.build(uriMatcherEl);
                    if (uriMatcher == null) continue;
                    gatekeeperConfig.addProtectedURI(uriMatcher);
                }
            } else {
                gatekeeperConfig.addProtectedURI(new URIMatcher());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Missing <ProtectedURIs> element. Assuming all incoming URIs are on the protected list");
                }
            }
            if ((nonProtectedURIsEl = gatekeeperProtectionControlEl.getFirstChildWithName(new QName(NON_PROTECTED_URIS_LN))) != null) {
                Iterator uriMatcherIt = nonProtectedURIsEl.getChildrenWithName(new QName("URIMatcher"));
                URIMatcherBuilder uriMatcherBuilder = new URIMatcherBuilder();
                while (uriMatcherIt != null && uriMatcherIt.hasNext()) {
                    OMElement uriMatcherEl = (OMElement)uriMatcherIt.next();
                    URIMatcher uriMatcher = (URIMatcher)uriMatcherBuilder.build(uriMatcherEl);
                    if (uriMatcher == null) continue;
                    gatekeeperConfig.addNonProtectedURI(uriMatcher);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Missing <NonProtectedURIs> element. No URIs are unprotected");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Missing <GatekeeperProtectionControl> element. Assuming all incoming URIs are on the protected list");
        }
        OMElement pkiConfigEl = el.getFirstChildWithName(new QName(PKI_CONFIG_LN));
        if (pkiConfigEl != null) {
            PKIConfigBuilder pkiConfigBuilder = new PKIConfigBuilder();
            gatekeeperConfig.setPKIConfig(pkiConfigBuilder.build(pkiConfigEl, gatekeeperConfig.getPKIConfig()));
        } else {
            log.warn((Object)"<PKIConfig> element is missing.");
        }
        Iterator it = el.getChildrenWithName(new QName(serviceConfigBuilder.getLocalName()));
        while (it != null && it.hasNext()) {
            OMElement next = (OMElement)it.next();
            GatekeeperServiceConfig serviceConfig = serviceConfigBuilder.build(next, null);
            if (serviceConfig != null) {
                gatekeeperConfig.addServiceConfig(serviceConfig);
                ++serviceConfigSuccess;
                continue;
            }
            ++serviceConfigFailed;
            log.error((Object)"Null service config returned from service config builder. Something went wrong");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully loaded " + serviceConfigSuccess + " service configurations. Failed to load: " + serviceConfigFailed));
        }
        return gatekeeperConfig;
    }
}

