/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.config.builder;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.configuration.builder.CoreConfigBuilder;
import org.eclipse.alf.security.sso.common.http.configuration.builder.PKIConfigBuilder;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.SOAPActionMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.URIMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.builder.SOAPActionMatcherBuilder;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.builder.URIMatcherBuilder;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProviderRegistry;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.SAML1PolicyBuilder;
import org.eclipse.alf.security.sso.common.util.FileIOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;

public class GatekeeperServiceConfigBuilder {
    private static final Logger log = Logger.getLogger(GatekeeperServiceConfigBuilder.class);
    public static final String SERVICE_CONFIG_LN = "Service";
    public static final String SERVICE_ENTRY_POINTS_LN = "ServiceEntryPoints";
    public static final String BROWSER_REQUESTS_LN = "BrowserRequests";
    public static final String SOAP_REQUESTS_LN = "SOAPRequests";
    public static final String DMZ_LN = "DMZ";
    public static final String RELYINGPARTY_LN = "RelyingParty";
    public static final String RELYINGPARTY_TYPE_LN = "Type";
    public static final String RELYINGPARTY_REALM_LN = "Realm";
    public static final String RELYINGPARTY_INSTANCE_LN = "Instance";
    public static final String LOCAL_LOGOUT_URI_LN = "LocalLogoutURI";
    public static final String GLOBAL_LOGOUT_URI_LN = "GlobalLogoutURI";
    public static final String CORE_CONFIG_LN = "CoreConfig";
    public static final String RELYING_PARTY_PKI_CONFIG_LN = "RelyingPartyPKIConfig";
    public static final String BROWSER_TOKEN_POLICIES_LN = "BrowserTokenPolicies";
    public static final String BROWSER_TOKEN_POLICY_LN = "BrowserTokenPolicy";
    public static final String WS_TOKEN_POLICIES_LN = "WSTokenPolicies";
    public static final String WS_TOKEN_POLICY_LN = "WSTokenPolicy";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_FILE = "file";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_PROTECTION_LEVEL = "protectionLevel";
    public static final String ATTR_TOKEN_TYPE = "tokenType";
    public static final String ATTRVALUE_TYPE_CALL_OUT = "out";
    public static final String ATTRVALUE_TYPE_CALL_IN = "in";
    public static final String ATTRVALUE_TYPE_CALL_INOUT = "inout";
    public static final String ATTRVALUE_PROTECTION_LEVEL_ALL = "all";
    public static final String ATTRVALUE_PROTECTION_LEVEL_SOAP = "soap";
    public static final String ATTRVALUE_PROTECTION_LEVEL_BROWSER = "browser";
    public static final String ATTR_NAME_DEFAULT = "default";
    public static final int ATTR_TYPE_DEFAULT = 1;
    public static final int ATTR_PROTECTION_LEVEL_DEFAULT = 2;
    protected String basePath = null;
    protected CoreConfig defaultCoreConfig = null;

    public GatekeeperServiceConfigBuilder() {
    }

    public GatekeeperServiceConfigBuilder(String basePath) {
        this.basePath = basePath;
    }

    public String getLocalName() {
        return SERVICE_CONFIG_LN;
    }

    public GatekeeperServiceConfig build(String configName) throws SSOException {
        GatekeeperServiceConfig retVal = null;
        InputStream is = FileIOHelper.loadResource((String)this.basePath, (String)configName);
        if (is != null) {
            retVal = this.build(is);
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                log.error((Object)"Error while closing input stream");
            }
        }
        return retVal;
    }

    public GatekeeperServiceConfig build(InputStream instream) throws SSOException {
        if (instream == null) {
            String errMsg = "Invalid input stream: null";
            log.error((Object)errMsg);
            throw new SSOException(errMsg);
        }
        StAXOMBuilder builder = null;
        try {
            builder = new StAXOMBuilder(instream);
        }
        catch (XMLStreamException e) {
            String errMsg = "Error obtaining StAXOMBuilder while trying to build config file object";
            log.error((Object)errMsg, (Throwable)e);
            throw new SSOException(errMsg, (Throwable)e);
        }
        if (builder == null) {
            String errMsg = "Failed to get a an StAXOMBuilder object: null";
            log.error((Object)errMsg);
            throw new SSOException(errMsg);
        }
        OMElement el = builder.getDocumentElement();
        if (el == null) {
            String errMsg = "The OM builder returned empty document";
            log.error((Object)errMsg);
            throw new SSOException(errMsg);
        }
        return this.build(el);
    }

    public GatekeeperServiceConfig build(OMElement element) throws SSOException {
        return this.build(element, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GatekeeperServiceConfig build(OMElement element, GatekeeperServiceConfig base) throws SSOException {
        KeystoreProviderRegistry coreKeystoreProviderRegistry;
        OMElement rpuriEl;
        boolean isCallInService;
        GatekeeperServiceConfig serviceConfig;
        OMElement el;
        block124: {
            ArrayList<URIMatcher> soapURIMatchersAdded;
            ArrayList<URIMatcher> browserURIMatchersAdded;
            OMElement dmzEl;
            int protectionLevel;
            block129: {
                OMElement soapRequestsURIsEl;
                block127: {
                    URIMatcher uriMatcher;
                    OMElement uriMatcherEl;
                    int urisAdded;
                    Iterator uriMatcherIt;
                    URIMatcherBuilder uriMatcherBuilder;
                    block128: {
                        block125: {
                            block126: {
                                block122: {
                                    block123: {
                                        block119: {
                                            block120: {
                                                block121: {
                                                    if (element == null) {
                                                        log.warn((Object)"ServiceConfigBuilder.build(null) called");
                                                        return null;
                                                    }
                                                    el = null;
                                                    el = element.getLocalName().equals(this.getLocalName()) ? element : element.getFirstChildWithName(new QName(this.getLocalName()));
                                                    if (el == null) {
                                                        log.error((Object)"ServiceConfigBuilder.build(): service config element cannot be found");
                                                        return null;
                                                    }
                                                    serviceConfig = null;
                                                    serviceConfig = base != null ? base : new GatekeeperServiceConfig();
                                                    String name = XMLHelper.getAttribute((OMElement)el, (String)ATTR_NAME);
                                                    if (name == null) {
                                                        log.debug((Object)"ServiceConfig @name attribute missing. Assuming: \"default\"");
                                                        name = ATTR_NAME_DEFAULT;
                                                    }
                                                    String typeString = XMLHelper.getAttribute((OMElement)el, (String)ATTR_TYPE);
                                                    int type = 1;
                                                    if (typeString == null) {
                                                        if (log.isDebugEnabled()) {
                                                            log.debug((Object)"ServiceConfig type attribute missing. Assuming: \"1\"");
                                                        }
                                                        type = 1;
                                                    } else if (typeString.equals(ATTRVALUE_TYPE_CALL_IN)) {
                                                        type = 1;
                                                    } else if (typeString.equals(ATTRVALUE_TYPE_CALL_OUT)) {
                                                        type = 0;
                                                    } else if (typeString.equals(ATTRVALUE_TYPE_CALL_INOUT)) {
                                                        type = 2;
                                                    } else {
                                                        if (log.isDebugEnabled()) {
                                                            log.debug((Object)"Unknown ServiceConfig type attribute. Assuming: \"1\"");
                                                        }
                                                        type = 1;
                                                    }
                                                    isCallInService = type == 1 || type == 2;
                                                    String protectionLevelString = XMLHelper.getAttribute((OMElement)el, (String)ATTR_PROTECTION_LEVEL);
                                                    protectionLevel = 2;
                                                    if (protectionLevelString == null) {
                                                        if (log.isDebugEnabled()) {
                                                            log.debug((Object)"ServiceConfig @protectionLevel attribute missing. Assuming: \"2\"");
                                                        }
                                                        protectionLevel = 2;
                                                    } else if (protectionLevelString.equals(ATTRVALUE_PROTECTION_LEVEL_ALL)) {
                                                        protectionLevel = 2;
                                                    } else if (protectionLevelString.equals(ATTRVALUE_PROTECTION_LEVEL_BROWSER)) {
                                                        protectionLevel = 1;
                                                    } else if (protectionLevelString.equals(ATTRVALUE_PROTECTION_LEVEL_SOAP)) {
                                                        protectionLevel = 0;
                                                    } else {
                                                        if (log.isDebugEnabled()) {
                                                            log.debug((Object)"Unknown ServiceConfig @protectionLevel attribute. Assuming: \"2\"");
                                                        }
                                                        protectionLevel = 2;
                                                    }
                                                    serviceConfig.setName(name);
                                                    serviceConfig.setType(type);
                                                    serviceConfig.setProtectionLevel(protectionLevel);
                                                    OMElement serviceURIsEl = el.getFirstChildWithName(new QName(SERVICE_ENTRY_POINTS_LN));
                                                    if (serviceURIsEl == null) break block119;
                                                    OMElement browserRequestsURIsEl = serviceURIsEl.getFirstChildWithName(new QName(BROWSER_REQUESTS_LN));
                                                    soapRequestsURIsEl = serviceURIsEl.getFirstChildWithName(new QName(SOAP_REQUESTS_LN));
                                                    dmzEl = serviceURIsEl.getFirstChildWithName(new QName(DMZ_LN));
                                                    browserURIMatchersAdded = new ArrayList<URIMatcher>();
                                                    soapURIMatchersAdded = new ArrayList<URIMatcher>();
                                                    if (browserRequestsURIsEl == null) break block120;
                                                    uriMatcherBuilder = new URIMatcherBuilder();
                                                    uriMatcherIt = browserRequestsURIsEl.getChildrenWithName(new QName("URIMatcher"));
                                                    if (uriMatcherIt != null && uriMatcherIt.hasNext()) break block121;
                                                    if (log.isDebugEnabled()) {
                                                        log.debug((Object)("No <URIMatcher> found under <" + browserRequestsURIsEl.getLocalName() + ">"));
                                                    }
                                                    break block122;
                                                }
                                                urisAdded = 0;
                                                break block123;
                                            }
                                            if (isCallInService) {
                                                log.warn((Object)"<BrowserRequests> element is missing. No browser requests will be authenticated.");
                                            }
                                            browserURIMatchersAdded = null;
                                            break block122;
                                        }
                                        if (!isCallInService) break block124;
                                        log.error((Object)"<ServiceEntryPoints> element is missing. Assuming all: (*) uris are applicable");
                                        serviceConfig.addBrowserServiceURIMatcher(new URIMatcher());
                                        serviceConfig.addSOAPServiceURIMather(new URIMatcher());
                                        serviceConfig.addSOAPActionMatcher(new SOAPActionMatcher());
                                        break block124;
                                    }
                                    while (uriMatcherIt != null && uriMatcherIt.hasNext()) {
                                        uriMatcherEl = (OMElement)uriMatcherIt.next();
                                        uriMatcher = (URIMatcher)uriMatcherBuilder.build(uriMatcherEl);
                                        if (uriMatcher != null) {
                                            serviceConfig.addBrowserServiceURIMatcher(uriMatcher);
                                            browserURIMatchersAdded.add(uriMatcher);
                                            ++urisAdded;
                                            if (!log.isDebugEnabled()) continue;
                                            log.debug((Object)("<" + uriMatcherBuilder.getLocalName() + "> element loaded: " + uriMatcher.toString()));
                                            continue;
                                        }
                                        log.error((Object)("Failed to build <" + uriMatcherBuilder.getLocalName() + "> element, skipping"));
                                    }
                                    if (urisAdded == 0) {
                                        log.warn((Object)"<BrowserRequests> element is missing. No browser requests will be authenticated.");
                                    }
                                }
                                if (soapRequestsURIsEl == null) break block125;
                                uriMatcherBuilder = new URIMatcherBuilder();
                                uriMatcherIt = soapRequestsURIsEl.getChildrenWithName(new QName("URIMatcher"));
                                if (uriMatcherIt != null && uriMatcherIt.hasNext()) break block126;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("No <URIMatcher> found under <" + soapRequestsURIsEl.getLocalName() + ">"));
                                }
                                break block127;
                            }
                            urisAdded = 0;
                            break block128;
                        }
                        if (isCallInService) {
                            log.warn((Object)"<SOAPRequests> element is missing.");
                        }
                        soapURIMatchersAdded = null;
                        break block129;
                    }
                    while (uriMatcherIt != null && uriMatcherIt.hasNext()) {
                        uriMatcherEl = (OMElement)uriMatcherIt.next();
                        uriMatcher = (URIMatcher)uriMatcherBuilder.build(uriMatcherEl);
                        if (uriMatcher != null) {
                            serviceConfig.addSOAPServiceURIMather(uriMatcher);
                            soapURIMatchersAdded.add(uriMatcher);
                            ++urisAdded;
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("<" + uriMatcherBuilder.getLocalName() + "> element loaded: " + uriMatcher.toString()));
                            continue;
                        }
                        log.error((Object)("Failed to build <" + uriMatcherBuilder.getLocalName() + "> element, skipping"));
                    }
                    if (urisAdded == 0) {
                        log.debug((Object)("No <" + uriMatcherBuilder.getLocalName() + "> elements found."));
                    }
                }
                SOAPActionMatcherBuilder soapActionMatcherBuilder = new SOAPActionMatcherBuilder();
                Iterator soapActionMatcherIt = soapRequestsURIsEl.getChildrenWithName(new QName("SOAPActionMatcher"));
                if (soapActionMatcherIt == null || !soapActionMatcherIt.hasNext()) {
                    log.error((Object)"<SOAPActionMatcher> element is missing. Assuming all: (*) soap actions are applicable");
                    serviceConfig.addSOAPActionMatcher(new SOAPActionMatcher());
                } else {
                    int soapActionsAdded = 0;
                    while (soapActionMatcherIt != null && soapActionMatcherIt.hasNext()) {
                        OMElement soapActionMatcherEl = (OMElement)soapActionMatcherIt.next();
                        SOAPActionMatcher soapActionMatcher = (SOAPActionMatcher)soapActionMatcherBuilder.build(soapActionMatcherEl);
                        if (soapActionMatcher != null) {
                            serviceConfig.addSOAPActionMatcher(soapActionMatcher);
                            ++soapActionsAdded;
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("<" + soapActionMatcherBuilder.getLocalName() + "> element loaded: " + soapActionMatcher.toString()));
                            continue;
                        }
                        log.error((Object)("Failed to build <" + soapActionMatcherBuilder.getLocalName() + "> element, skipping"));
                    }
                    if (soapActionsAdded == 0) {
                        if (soapURIMatchersAdded.size() > 0) {
                            serviceConfig.addSOAPActionMatcher(new SOAPActionMatcher());
                        } else {
                            log.debug((Object)("No <" + soapActionMatcherBuilder.getLocalName() + "> elements found."));
                        }
                    }
                }
            }
            if (isCallInService) {
                if ((protectionLevel == 2 || protectionLevel == 1) && browserURIMatchersAdded == null && soapURIMatchersAdded != null && soapURIMatchersAdded.size() > 0) {
                    for (URIMatcher uriMatcher : soapURIMatchersAdded) {
                        serviceConfig.addBrowserServiceURIMatcher(uriMatcher);
                    }
                }
                if ((protectionLevel == 2 || protectionLevel == 0) && soapURIMatchersAdded == null && browserURIMatchersAdded != null && browserURIMatchersAdded.size() > 0) {
                    for (URIMatcher uriMatcher : browserURIMatchersAdded) {
                        serviceConfig.addSOAPServiceURIMather(uriMatcher);
                    }
                }
            }
            if (dmzEl != null) {
                URIMatcher uriMatcher;
                Iterator uriMatcherIt;
                OMElement dmzbrowserRequestsURIsEl = dmzEl.getFirstChildWithName(new QName(BROWSER_REQUESTS_LN));
                OMElement dmzsoapRequestsURIsEl = dmzEl.getFirstChildWithName(new QName(SOAP_REQUESTS_LN));
                if (dmzbrowserRequestsURIsEl != null) {
                    URIMatcherBuilder uriMatcherBuilder = new URIMatcherBuilder();
                    uriMatcherIt = dmzbrowserRequestsURIsEl.getChildrenWithName(new QName("URIMatcher"));
                    if (uriMatcherIt != null && uriMatcherIt.hasNext()) {
                        while (uriMatcherIt != null && uriMatcherIt.hasNext()) {
                            OMElement uriMatcherEl = (OMElement)uriMatcherIt.next();
                            uriMatcher = (URIMatcher)uriMatcherBuilder.build(uriMatcherEl);
                            if (uriMatcher != null) {
                                serviceConfig.addDMZBrowserServiceURIMatcher(uriMatcher);
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)("<" + uriMatcherBuilder.getLocalName() + "> element loaded: " + uriMatcher.toString()));
                                continue;
                            }
                            log.error((Object)("Failed to build <" + uriMatcherBuilder.getLocalName() + "> element, skipping"));
                        }
                    }
                }
                if (dmzsoapRequestsURIsEl != null) {
                    URIMatcherBuilder uriMatcherBuilder = new URIMatcherBuilder();
                    uriMatcherIt = dmzsoapRequestsURIsEl.getChildrenWithName(new QName("URIMatcher"));
                    if (uriMatcherIt != null && uriMatcherIt.hasNext()) {
                        while (uriMatcherIt != null && uriMatcherIt.hasNext()) {
                            OMElement uriMatcherEl = (OMElement)uriMatcherIt.next();
                            uriMatcher = (URIMatcher)uriMatcherBuilder.build(uriMatcherEl);
                            if (uriMatcher != null) {
                                serviceConfig.addDMZSOAPServiceURIMatcher(uriMatcher);
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)("<" + uriMatcherBuilder.getLocalName() + "> element loaded: " + uriMatcher.toString()));
                                continue;
                            }
                            log.error((Object)("Failed to build <" + uriMatcherBuilder.getLocalName() + "> element, skipping"));
                        }
                    }
                    SOAPActionMatcherBuilder soapActionMatcherBuilder = new SOAPActionMatcherBuilder();
                    Iterator soapActionMatcherIt = dmzsoapRequestsURIsEl.getChildrenWithName(new QName("SOAPActionMatcher"));
                    if (soapActionMatcherIt != null && soapActionMatcherIt.hasNext()) {
                        while (soapActionMatcherIt != null && soapActionMatcherIt.hasNext()) {
                            OMElement soapActionMatcherEl = (OMElement)soapActionMatcherIt.next();
                            SOAPActionMatcher soapActionMatcher = (SOAPActionMatcher)soapActionMatcherBuilder.build(soapActionMatcherEl);
                            if (soapActionMatcher != null) {
                                serviceConfig.addDMZSOAPActionMatcher(soapActionMatcher);
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)("<" + soapActionMatcherBuilder.getLocalName() + "> element loaded: " + soapActionMatcher.toString()));
                                continue;
                            }
                            log.error((Object)("Failed to build <" + soapActionMatcherBuilder.getLocalName() + "> element, skipping"));
                        }
                    }
                }
            }
        }
        if ((rpuriEl = el.getFirstChildWithName(new QName(RELYINGPARTY_LN))) != null) {
            String rpType = null;
            OMElement rpTypeEl = rpuriEl.getFirstChildWithName(new QName(RELYINGPARTY_TYPE_LN));
            if (rpTypeEl != null) {
                rpType = rpTypeEl.getText().trim();
            }
            if (StringHelper.isBlank(rpType)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"<Type> element is missing. Assuming \"anonymous\"");
                }
                rpType = "anonymous";
            }
            String rpRealm = null;
            OMElement rpRealmEl = rpuriEl.getFirstChildWithName(new QName(RELYINGPARTY_REALM_LN));
            if (rpRealmEl != null) {
                rpRealm = rpRealmEl.getText().trim();
            }
            if (StringHelper.isBlank(rpRealm)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"<Realm> element is missing. Assuming \"anonymous\"");
                }
                rpRealm = "anonymous";
            }
            String rpInstance = null;
            OMElement rpInstanceEl = rpuriEl.getFirstChildWithName(new QName(RELYINGPARTY_INSTANCE_LN));
            if (rpInstanceEl != null) {
                rpInstance = rpInstanceEl.getText().trim();
            }
            if (StringHelper.isBlank(rpInstance)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"<Instance> element is missing. Assuming \"anonymous\"");
                }
                rpInstance = "anonymous";
            }
            RPURI rpuri = null;
            try {
                rpuri = new RPURI(rpType, rpRealm, rpInstance);
            }
            catch (SSOException e) {
                log.error((Object)("<RelyingParty> element contains invalid data and cannot be used as relying party identification URI: rpType=\"" + rpType + "\", " + "rpRealm=\"" + rpRealm + "\", " + "rpInstance=\"" + rpInstance + "\""));
                return null;
            }
            serviceConfig.setRpuri(rpuri);
            if (log.isDebugEnabled()) {
                log.debug((Object)("<RelyingParty> element parsed: " + rpuri.toString()));
            }
        } else {
            if (!log.isDebugEnabled()) return null;
            log.debug((Object)"<RelyingParty> element is missing");
            return null;
        }
        OMElement globalLogoutURIEl = el.getFirstChildWithName(new QName(GLOBAL_LOGOUT_URI_LN));
        if (globalLogoutURIEl != null) {
            OMElement uriMatcherEl = globalLogoutURIEl.getFirstChildWithName(new QName("URIMatcher"));
            if (uriMatcherEl != null) {
                URIMatcherBuilder uriMatcherBuilder = new URIMatcherBuilder();
                URIMatcher uriMatcher = (URIMatcher)uriMatcherBuilder.build(uriMatcherEl);
                if (uriMatcher == null) {
                    log.error((Object)("Error parsing logout URI for serivice \"" + serviceConfig.getName() + "\""));
                    return null;
                }
                serviceConfig.setGlobalLogoutURI(uriMatcher);
            } else {
                log.warn((Object)("<GlobalLogoutURI><URIMatcher> element is missing for service + \"" + serviceConfig.getName() + "\". Logout will not be possible for this service"));
            }
        } else {
            if (isCallInService) {
                log.warn((Object)"<GlobalLogoutURI> element is missing. Logout redirect is disabled for this service");
            }
            serviceConfig.setGlobalLogoutURI(null);
        }
        OMElement logoutURIEl = el.getFirstChildWithName(new QName(LOCAL_LOGOUT_URI_LN));
        if (logoutURIEl != null) {
            OMElement uriMatcherEl = logoutURIEl.getFirstChildWithName(new QName("URIMatcher"));
            if (uriMatcherEl != null) {
                URIMatcherBuilder uriMatcherBuilder = new URIMatcherBuilder();
                URIMatcher uriMatcher = (URIMatcher)uriMatcherBuilder.build(uriMatcherEl);
                if (uriMatcher == null) {
                    log.error((Object)("Error parsing logout URI for serivice \"" + serviceConfig.getName() + "\""));
                    return null;
                }
                serviceConfig.setLocalLogoutURI(uriMatcher);
            } else {
                log.warn((Object)("<LocalLogoutURI><URIMatcher> element is missing for service + \"" + serviceConfig.getName() + "\". Logout will not be possible for this service"));
            }
        } else {
            if (isCallInService) {
                log.warn((Object)"<LocalLogoutURI> element is missing. Logout redirect is disabled for this service");
            }
            serviceConfig.setLocalLogoutURI(null);
        }
        OMElement pkiConfigEl = el.getFirstChildWithName(new QName(RELYING_PARTY_PKI_CONFIG_LN));
        if (pkiConfigEl != null) {
            PKIConfigBuilder pkiConfigBuilder = new PKIConfigBuilder();
            serviceConfig.setPKIConfig(pkiConfigBuilder.build(pkiConfigEl, serviceConfig.getPKIConfig()));
        } else {
            log.warn((Object)"<RelyingPartyPKIConfig> element is missing.");
        }
        OMElement configEl = el.getFirstChildWithName(new QName(CORE_CONFIG_LN));
        String configFile = XMLHelper.getAttribute((OMElement)configEl, (String)ATTR_FILE);
        if (configEl != null) {
            CoreConfig coreConfig = this.defaultCoreConfig;
            CoreConfigBuilder builder = new CoreConfigBuilder(this.basePath);
            if (StringHelper.isNotBlank((String)configFile)) {
                InputStream is = FileIOHelper.loadResource((String)this.basePath, (String)configFile);
                if (is != null) {
                    coreConfig = builder.build(is, coreConfig);
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing input stream");
                    }
                    if (coreConfig == null) {
                        log.error((Object)"Failed to load core configuration");
                    }
                } else {
                    log.error((Object)("Failed to load CoreConfig from \"" + configFile + "\" (basePath=\"" + this.basePath + "\""));
                }
            }
            coreConfig = builder.build(configEl, coreConfig);
            serviceConfig.setCoreConfig(coreConfig);
        } else {
            log.warn((Object)"<CoreConfig> element is missing. Assuming defaults.");
            serviceConfig.setCoreConfig(new CoreConfig());
        }
        SAML1PolicyBuilder samlPolicyBuilder = new SAML1PolicyBuilder();
        OMElement browserTokenPoliciesEl = el.getFirstChildWithName(new QName(BROWSER_TOKEN_POLICIES_LN));
        Iterator policiesIterator = null;
        if (browserTokenPoliciesEl != null) {
            policiesIterator = browserTokenPoliciesEl.getChildrenWithName(new QName(BROWSER_TOKEN_POLICY_LN));
        }
        if (policiesIterator == null) {
            log.warn((Object)"<BrowserTokenPolicy> element is missing. Using defaults");
            SAML1Policy browserTokenPolicy = new SAML1Policy();
            serviceConfig.addBrowserTokenPolicy("*", browserTokenPolicy);
        } else {
            while (policiesIterator.hasNext()) {
                OMElement browserTokenPolicyEl = (OMElement)policiesIterator.next();
                String browserTokenPolicyFile = XMLHelper.getAttribute((OMElement)browserTokenPolicyEl, (String)ATTR_FILE);
                String browserTokenPolicyTokenType = XMLHelper.getAttribute((OMElement)browserTokenPolicyEl, (String)ATTR_TOKEN_TYPE);
                if (StringHelper.isBlank((String)browserTokenPolicyTokenType)) {
                    browserTokenPolicyTokenType = "*";
                }
                if (StringHelper.isBlank((String)browserTokenPolicyFile)) {
                    SAML1Policy browserTokenPolicy = (SAML1Policy)samlPolicyBuilder.build(browserTokenPolicyEl);
                    if (serviceConfig.getCoreConfig() != null && serviceConfig.getCoreConfig().getKeystoreProviderRegistry() != null) {
                        KeystoreProviderRegistry coreKeystoreProviderRegistry2 = serviceConfig.getCoreConfig().getKeystoreProviderRegistry();
                        KeystoreProviderRegistry browserTokenPolicyKeystoreProviderRegistry = browserTokenPolicy.getKeystoreProviderRegistry();
                        browserTokenPolicyKeystoreProviderRegistry.addOrReplaceKeystoreRegistry(coreKeystoreProviderRegistry2);
                    }
                    serviceConfig.addBrowserTokenPolicy(browserTokenPolicyTokenType, browserTokenPolicy);
                    continue;
                }
                InputStream is = FileIOHelper.loadResource((String)this.basePath, (String)browserTokenPolicyFile);
                if (is != null) {
                    SAML1Policy browserTokenPolicy = (SAML1Policy)samlPolicyBuilder.build(is);
                    if (serviceConfig.getCoreConfig() != null && serviceConfig.getCoreConfig().getKeystoreProviderRegistry() != null) {
                        coreKeystoreProviderRegistry = serviceConfig.getCoreConfig().getKeystoreProviderRegistry();
                        KeystoreProviderRegistry browserTokenPolicyKeystoreProviderRegistry = browserTokenPolicy.getKeystoreProviderRegistry();
                        browserTokenPolicyKeystoreProviderRegistry.addOrReplaceKeystoreRegistry(coreKeystoreProviderRegistry);
                    }
                    serviceConfig.addBrowserTokenPolicy(browserTokenPolicyTokenType, browserTokenPolicy);
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing input stream");
                    }
                    continue;
                }
                log.error((Object)("Failed to load BrowserTokenPolicy from \"" + browserTokenPolicyFile + "\" (basePath=\"" + this.basePath + "\""));
            }
        }
        OMElement wsTokenPoliciesEl = el.getFirstChildWithName(new QName(WS_TOKEN_POLICIES_LN));
        policiesIterator = null;
        if (browserTokenPoliciesEl != null) {
            policiesIterator = wsTokenPoliciesEl.getChildrenWithName(new QName(WS_TOKEN_POLICY_LN));
        }
        if (policiesIterator == null) {
            log.warn((Object)"<WSTokenPolicy> element is missing. Using defaults");
            SAML1Policy wsTokenPolicy = new SAML1Policy();
            serviceConfig.addWsTokenPolicy("*", wsTokenPolicy);
            return serviceConfig;
        } else {
            while (policiesIterator.hasNext()) {
                OMElement wsTokenPolicyEl = (OMElement)policiesIterator.next();
                String wsTokenPolicyFile = XMLHelper.getAttribute((OMElement)wsTokenPolicyEl, (String)ATTR_FILE);
                String wsTokenPolicyTokenType = XMLHelper.getAttribute((OMElement)wsTokenPolicyEl, (String)ATTR_TOKEN_TYPE);
                if (StringHelper.isBlank((String)wsTokenPolicyTokenType)) {
                    wsTokenPolicyTokenType = "*";
                }
                if (StringHelper.isBlank((String)wsTokenPolicyFile)) {
                    SAML1Policy wsTokenPolicy = (SAML1Policy)samlPolicyBuilder.build(wsTokenPolicyEl);
                    if (serviceConfig.getCoreConfig() != null && serviceConfig.getCoreConfig().getKeystoreProviderRegistry() != null) {
                        coreKeystoreProviderRegistry = serviceConfig.getCoreConfig().getKeystoreProviderRegistry();
                        KeystoreProviderRegistry wsTokenPolicyKeystoreProviderRegistry = wsTokenPolicy.getKeystoreProviderRegistry();
                        wsTokenPolicyKeystoreProviderRegistry.addOrReplaceKeystoreRegistry(coreKeystoreProviderRegistry);
                    }
                    serviceConfig.addWsTokenPolicy(wsTokenPolicyTokenType, wsTokenPolicy);
                    continue;
                }
                InputStream is = FileIOHelper.loadResource((String)this.basePath, (String)wsTokenPolicyFile);
                if (is != null) {
                    SAML1Policy wsTokenPolicy = (SAML1Policy)samlPolicyBuilder.build(is);
                    if (serviceConfig.getCoreConfig() != null && serviceConfig.getCoreConfig().getKeystoreProviderRegistry() != null) {
                        KeystoreProviderRegistry coreKeystoreProviderRegistry3 = serviceConfig.getCoreConfig().getKeystoreProviderRegistry();
                        KeystoreProviderRegistry wsTokenPolicyKeystoreProviderRegistry = wsTokenPolicy.getKeystoreProviderRegistry();
                        wsTokenPolicyKeystoreProviderRegistry.addOrReplaceKeystoreRegistry(coreKeystoreProviderRegistry3);
                    }
                    serviceConfig.addWsTokenPolicy(wsTokenPolicyTokenType, wsTokenPolicy);
                } else {
                    log.error((Object)("Failed to load WSTokenPolicy from \"" + wsTokenPolicyFile + "\" (basePath=\"" + this.basePath + "\""));
                }
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing input stream");
                }
            }
        }
        return serviceConfig;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setDefaultCoreConfig(CoreConfig defaultCoreConfig) {
        this.defaultCoreConfig = defaultCoreConfig;
    }
}

