/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.handler;

import org.apache.axis2.AxisFault;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.configuration.PrincipalEndorsmentConfig;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProvider;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTCallProxy;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecurityContext;
import org.eclipse.alf.security.sso.common.ws.message.trust.RSTRequest;
import org.eclipse.alf.security.sso.common.ws.message.trust.issue.RSTIssueRequest;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.UsernameToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityTokenResponse;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.soap.secctx.SecCtxSTSTokenExchange;

public class TokenExchangeHelper {
    private static final Logger log = Logger.getLogger(TokenExchangeHelper.class);

    public static String getSSOTokenWithUsernameOnly(String username, String ssoTokenType, String rpuri) throws SSOException {
        try {
            new RPURI(rpuri);
        }
        catch (SSOException e) {
            String errorMessage = "Invalid relying party URI: \"" + rpuri + "\"";
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException(errorMessage, (Throwable)e);
        }
        GatekeeperServiceConfig serviceConfig = GatekeeperConfig.getInstance().getServiceConfigByRPURI(rpuri);
        if (serviceConfig == null) {
            String errorMessage = "Failed to find matching configuration for relying party: \"" + rpuri + "\"";
            log.error((Object)errorMessage);
            throw new SSOException(errorMessage);
        }
        CoreConfig coreconf = serviceConfig.getCoreConfig();
        if (coreconf == null) {
            String errorMessage = "Invalid configuration object for relying party: \"" + rpuri + "\"";
            log.error((Object)errorMessage);
            throw new SSOException(errorMessage);
        }
        PrincipalEndorsmentConfig principalEndorsmentConfig = coreconf.getPrincipalEndorsmentConfig(GatekeeperConfig.getInstance().getPKIConfig(), serviceConfig.getPKIConfig());
        SSOToken token = TokenExchangeHelper.requestSecurityTokenUT(username, null, ssoTokenType, rpuri, null, null, coreconf, principalEndorsmentConfig);
        if (token != null) {
            return token.toString();
        }
        return null;
    }

    public static String getSSOTokenWithUsernameAndPassword(String username, String password, String ssoTokenType, String rpuri) throws SSOException {
        try {
            new RPURI(rpuri);
        }
        catch (SSOException e) {
            String errorMessage = "Invalid relying party URI: \"" + rpuri + "\"";
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException(errorMessage, (Throwable)e);
        }
        GatekeeperServiceConfig serviceConfig = GatekeeperConfig.getInstance().getServiceConfigByRPURI(rpuri);
        if (serviceConfig == null) {
            String errorMessage = "Failed to find matching configuration for relying party: \"" + rpuri + "\"";
            log.error((Object)errorMessage);
            throw new SSOException(errorMessage);
        }
        CoreConfig coreconf = serviceConfig.getCoreConfig();
        if (coreconf == null) {
            String errorMessage = "Invalid configuration object for relying party: \"" + rpuri + "\"";
            log.error((Object)errorMessage);
            throw new SSOException(errorMessage);
        }
        SSOToken token = TokenExchangeHelper.requestSecurityTokenUT(username, password, ssoTokenType, rpuri, null, null, coreconf, null);
        return token.toString();
    }

    public static SSOToken getSSOTokenWithExpiredToken(SSOToken expiredToken, String rpuri) throws SSOException {
        try {
            new RPURI(rpuri);
        }
        catch (SSOException e) {
            String errorMessage = "Invalid relying party URI: \"" + rpuri + "\"";
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException(errorMessage, (Throwable)e);
        }
        GatekeeperServiceConfig serviceConfig = GatekeeperConfig.getInstance().getServiceConfigByRPURI(rpuri);
        if (serviceConfig == null) {
            String errorMessage = "Failed to find matching configuration for relying party: \"" + rpuri + "\"";
            log.error((Object)errorMessage);
            throw new SSOException(errorMessage);
        }
        CoreConfig coreconf = serviceConfig.getCoreConfig();
        if (coreconf == null) {
            String errorMessage = "Invalid configuration object for relying party: \"" + rpuri + "\"";
            log.error((Object)errorMessage);
            throw new SSOException(errorMessage);
        }
        PrincipalEndorsmentConfig principalEndorsmentConfig = coreconf.getPrincipalEndorsmentConfig(GatekeeperConfig.getInstance().getPKIConfig(), serviceConfig.getPKIConfig());
        SSOToken newToken = TokenExchangeHelper.requestSecurityTokenUT(expiredToken.getSubjectName(), null, expiredToken.getTokenType(), rpuri, null, new Long(expiredToken.getNotOnOrAfter().getTime() - expiredToken.getNotBefore().getTime()), coreconf, principalEndorsmentConfig);
        return newToken;
    }

    private static SSOToken requestSecurityTokenUT(String username, String password, String tokenType, String rpuri, String stsEPR, Long requestedLifetime, CoreConfig coreconf, PrincipalEndorsmentConfig principalEndorsmentConfig) throws SSOException {
        SecCtxSTSTokenExchange secCtx = new SecCtxSTSTokenExchange();
        String fedServerURL = coreconf.getParameter("SecurityTokenService", "http://localhost/TokenService/services/Trust");
        long ttl = coreconf.getLongParameter("SecurityTokenTTL", 28800L);
        if (StringHelper.isNotBlank((String)fedServerURL)) {
            stsEPR = fedServerURL;
        }
        if (StringHelper.isBlank((String)stsEPR)) {
            log.error((Object)"New token request: unknown STS location");
            throw new SSOException("New token request: unknown STS location");
        }
        if (requestedLifetime != null) {
            ttl = requestedLifetime;
        }
        UsernameToken onBehalfOfUsernameToken = null;
        if (principalEndorsmentConfig != null) {
            if (principalEndorsmentConfig.getType() == 1 || principalEndorsmentConfig.getType() == 3) {
                onBehalfOfUsernameToken = WSAbstractFactory.getWSSEObjectFactory().createUsernameToken(username, password);
                username = principalEndorsmentConfig.getUsername();
                password = principalEndorsmentConfig.getPassword();
            }
            if (principalEndorsmentConfig.getType() == 2 || principalEndorsmentConfig.getType() == 3) {
                KeystoreProvider ksProvider = coreconf.getKeystoreProvider(principalEndorsmentConfig.getKeystoreId());
                secCtx.setKeystoreProvider(ksProvider);
                secCtx.setSigCertAlias(principalEndorsmentConfig.getCertAlias());
                secCtx.setSigCertAliasPassword(principalEndorsmentConfig.getSigningCertPassword());
                secCtx.setSigCertInclusionMethod(principalEndorsmentConfig.getCertInclusionMethod());
            }
        }
        RSTIssueRequest request = new RSTIssueRequest();
        RSTCallProxy callProxy = null;
        secCtx.setOfcUsername(username);
        secCtx.setOfcPassword(password);
        request.setAppliesTo(rpuri);
        request.setSSOTokenType(tokenType);
        request.setEpr(stsEPR);
        request.setTtl(ttl);
        request.setOnBehalfOfSecurityToken((SecurityToken)onBehalfOfUsernameToken);
        request.setSecurityContext((SecurityContext)secCtx);
        try {
            callProxy = new RSTCallProxy(coreconf.getAxis2ConfigurationContext());
        }
        catch (SSOException e) {
            log.error((Object)"Error creating RST call proxy", (Throwable)e);
            throw e;
        }
        if (callProxy == null) {
            throw new SSOException("Error creating RST call proxy");
        }
        RequestSecurityTokenResponse rstr = null;
        try {
            rstr = callProxy.invoke((RSTRequest)request);
        }
        catch (AxisFault e) {
            log.error((Object)"Axis fault caught while issuing a SOAP call to STS.", (Throwable)e);
            throw new SSOException("Axis fault caught while issuing a SOAP call to STS.", (Throwable)e);
        }
        catch (SSOException e) {
            log.error((Object)"SSO exception while issuing a SOAP call to STS.", (Throwable)e);
            throw e;
        }
        SSOToken token = SSOTokenFactory.createSSOToken((SecurityToken)rstr.getRequestedSecurityToken().getSecurityToken());
        return token;
    }
}

