/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.html;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.server.gatekeeper.html.ErrorPageGenerator;
import org.eclipse.alf.security.sso.server.gatekeeper.html.WSFedRedirectPageGenerator;

public class HTMLFactory {
    static final Logger log = Logger.getLogger(HTMLFactory.class);

    public static void setApplicationErrorResponse(HttpServletRequest req, HttpServletResponse resp, CoreConfig coreConfig, String applicationErrorMessage, String applicationDetailedErrorMessage) throws ServletException {
        log.info((Object)"Redirecting to application error page.");
        if (coreConfig == null) {
            log.error((Object)"Invalid arguments");
            throw new ServletException("Invalid configuration parameters");
        }
        String pageErrorGeneratorClass = coreConfig.getParameter("PageErrorGeneratorClass", "org.eclipse.alf.security.sso.server.gatekeeper.html.impl.ErrorPageGeneratorImpl");
        if (StringHelper.isBlank((String)pageErrorGeneratorClass)) {
            log.error((Object)"Empty error page generator class name: empty, defaulting to: \"PageErrorGeneratorClass\"");
            pageErrorGeneratorClass = "org.eclipse.alf.security.sso.server.gatekeeper.html.impl.ErrorPageGeneratorImpl";
        }
        ClassLoader cl = null;
        try {
            cl = coreConfig.getClass().getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
        }
        catch (SecurityException e) {
            log.error((Object)("Error instantiating class: security error:" + e.getMessage()));
            throw new ServletException("Error instantiating class: security error:" + e.getMessage(), (Throwable)e);
        }
        Object obj = null;
        try {
            obj = SSOHelper.loadObject((ClassLoader)cl, (String)pageErrorGeneratorClass);
        }
        catch (SSOException e) {
            String errorMessage = "Error instantiating class: " + e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new ServletException(errorMessage, (Throwable)e);
        }
        if (!(obj instanceof ErrorPageGenerator)) {
            String errorMessage = "Error instantiating class: incompatible class type";
            log.error((Object)errorMessage);
            throw new ServletException(errorMessage);
        }
        ErrorPageGenerator errorPageGenerator = (ErrorPageGenerator)obj;
        try {
            errorPageGenerator.generateErrorPage(req, resp, coreConfig, applicationErrorMessage, applicationDetailedErrorMessage);
        }
        catch (Throwable e) {
            String errorMessage = "Error generating error page: " + e.getMessage();
            log.error((Object)errorMessage, e);
            throw new ServletException(errorMessage, e);
        }
    }

    public static void postRedirectWSFedData(HttpServletRequest req, HttpServletResponse resp, CoreConfig coreConfig, String fedServerURL, WSFedData wsfData) throws ServletException {
        if (coreConfig == null) {
            log.error((Object)"Invalid arguments");
            throw new ServletException("Invalid configuration parameters");
        }
        String wsfRedirectPageGeneratorClass = coreConfig.getParameter("PageRedirectGeneratorClass", "org.eclipse.alf.security.sso.server.gatekeeper.html.impl.WSFedRedirectPageGeneratorImpl");
        if (StringHelper.isBlank((String)wsfRedirectPageGeneratorClass)) {
            log.error((Object)"Empty redirect HTML generator class name: empty, defaulting to: \"org.eclipse.alf.security.sso.server.gatekeeper.html.impl.WSFedRedirectPageGeneratorImpl\"");
            wsfRedirectPageGeneratorClass = "org.eclipse.alf.security.sso.server.gatekeeper.html.impl.WSFedRedirectPageGeneratorImpl";
        }
        ClassLoader cl = null;
        try {
            cl = coreConfig.getClass().getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
        }
        catch (SecurityException e) {
            log.error((Object)("Error instantiating class: security error:" + e.getMessage()));
            throw new ServletException("Error instantiating class: security error:" + e.getMessage(), (Throwable)e);
        }
        Object obj = null;
        try {
            obj = SSOHelper.loadObject((ClassLoader)cl, (String)wsfRedirectPageGeneratorClass);
        }
        catch (SSOException e) {
            String errorMessage = "Error instantiating class: " + e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new ServletException(errorMessage, (Throwable)e);
        }
        if (!(obj instanceof WSFedRedirectPageGenerator)) {
            String errorMessage = "Error instantiating class: incompatible class type";
            log.error((Object)errorMessage);
            throw new ServletException(errorMessage);
        }
        WSFedRedirectPageGenerator wsfRedirectPageGenerator = (WSFedRedirectPageGenerator)obj;
        try {
            wsfRedirectPageGenerator.genereateWSFedRedirectPage(req, resp, coreConfig, fedServerURL, wsfData);
        }
        catch (Throwable e) {
            String errorMessage = "Error generating WS-Federation Redirect Page: " + e.getMessage();
            log.error((Object)errorMessage, e);
            throw new ServletException(errorMessage, e);
        }
    }
}

