/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.soap.secctx;

import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.rampart.handler.config.OutflowConfiguration;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProvider;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.PWCallbackDynamic;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecurityContext;

public class SecCtxSTSTokenExchange
extends SecurityContext {
    static final Logger log = Logger.getLogger(SecCtxSTSTokenExchange.class);
    private boolean doSignature = false;
    private boolean doUsernameToken = false;
    private KeystoreProvider ksProvider = null;
    private String sigCertAlias = null;
    private String sigCertAliasPassword = null;
    private String sigCertInclusionMethod = null;

    public void setKeystoreProvider(KeystoreProvider ksProvider) {
        this.ksProvider = ksProvider;
    }

    public void setSigCertAlias(String sigCertAlias) {
        this.sigCertAlias = sigCertAlias;
    }

    public void setSigCertAliasPassword(String sigCertAliasPassword) {
        this.sigCertAliasPassword = sigCertAliasPassword;
    }

    public void setSigCertInclusionMethod(String sigCertInclusionMethod) {
        this.sigCertInclusionMethod = sigCertInclusionMethod;
    }

    public OutflowConfiguration getOfc() {
        PWCallbackDynamic callback = new PWCallbackDynamic();
        this.doSignature = this.ksProvider != null && this.ksProvider.getKeystoreFile() != null;
        this.doUsernameToken = StringHelper.isNotBlank((String)this.getOfcUsername());
        String sigParts = "{Element}{http://schemas.xmlsoap.org/ws/2004/08/addressing}MessageID;{Element}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp";
        if (this.doSignature) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using keystore from \"" + this.ksProvider.getKeystoreFile() + "\""));
            }
            Properties prop1 = new Properties();
            prop1.setProperty("org.apache.ws.security.crypto.provider", "org.apache.ws.security.components.crypto.Merlin");
            prop1.setProperty("org.apache.ws.security.crypto.merlin.file", this.ksProvider.getKeystoreFile());
            prop1.setProperty("org.apache.ws.security.crypto.merlin.keystore.type", this.ksProvider.getKeystoreType());
            prop1.setProperty("org.apache.ws.security.crypto.merlin.keystore.password", this.ksProvider.getKeystorePassword());
            this.optionProperties.put("crypto_props", prop1);
            this.optionProperties.put("crypto_props1", prop1);
        }
        OutflowConfiguration ofc = null;
        ofc = this.doUsernameToken && this.doSignature ? new OutflowConfiguration(2) : new OutflowConfiguration();
        String actionItems1 = "Timestamp";
        String actionItems2 = "";
        if (this.doUsernameToken) {
            actionItems1 = actionItems1 + " UsernameToken";
        }
        if (this.doSignature) {
            actionItems2 = actionItems2 + "Signature";
        }
        if (this.doUsernameToken) {
            ofc.setActionItems(actionItems1);
            ofc.setUser(this.getOfcUsername());
            ofc.setPasswordType("PasswordText");
            callback.setUsernameTokenUsername(this.getOfcUsername());
            callback.setUsernameTokenPassword(this.getOfcPassword());
            ofc.setSignaturePropRefId("crypto_props");
        }
        if (this.doSignature) {
            ofc.nextAction();
            ofc.setActionItems(actionItems2);
            ofc.setUser(this.sigCertAlias);
            ofc.setSignatureKeyIdentifier(this.sigCertInclusionMethod);
            ofc.setSignaturePropRefId("crypto_props");
            ofc.setOptimizeParts("//xenc:EncryptedData/xenc:CipherData/xenc:CipherValue");
            callback.setSignatureKeyAlias(this.sigCertAlias.getBytes());
            callback.setKeystorePassword(this.ksProvider.getKeystorePassword());
            ofc.previousAction();
        }
        if (this.doUsernameToken || this.doSignature) {
            this.ofcPasswordCallbackHandler = callback;
            this.optionProperties.put("passwordCallbackRef", callback);
            this.optionProperties.put("passwordCallbackRef1", callback);
        }
        this.ofc = ofc;
        return ofc;
    }
}

