/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventemitter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.components.uuid.SimpleUUIDGen;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EventEmitter
extends Thread {
    private static Logger logger = Logger.getLogger(EventEmitter.class);
    private static SimpleUUIDGen UUIDGen = new SimpleUUIDGen();
    private static final String WSSE_V10_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String WSSE_SECURITY_HEADER_ELEMENT_NAME = "Security";
    private String filename;
    private String schemaFilename = "";
    private String serverURL;
    private int waitTime = 0;
    private int timeout = 30;
    private String eventId = "";
    private String timestamp = "";
    private String eventType = "";
    private String objectId = "";
    private String objectType = "";
    private String product = "";
    private String productVersion = "";
    private String productInstance = "";
    private SOAPBodyElement alfEvent;

    public EventEmitter(String string, String string2, String string3, int n, int n2) {
        this.setFilename(string);
        this.setServerURL(string2);
        this.setSchemaFilename(string3);
        this.setWaitTime(n);
        this.setTimeout(n2);
    }

    public EventEmitter() {
    }

    public void load() {
        this.alfEvent = this.loadSOAPBody();
    }

    public synchronized void run() {
        try {
            if (this.waitTime > 0) {
                EventEmitter.sleep(this.waitTime * 1000);
            }
            try {
                this.raiseEvent();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public synchronized void raiseEvent() throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Event Raised for : ");
        stringBuffer.append("\n\n");
        stringBuffer.append("Event ID: " + this.getEventId() + "\n");
        stringBuffer.append("Timestamp: " + this.getTimestamp() + "\n");
        stringBuffer.append("Event Type: " + this.getEventType() + "\n");
        stringBuffer.append("Object Type: " + this.getObjectType() + "\n");
        stringBuffer.append("Object ID: " + this.getObjectId() + "\n");
        stringBuffer.append("Product: " + this.getProduct() + "\n");
        stringBuffer.append("Version: " + this.getProductVersion() + "\n");
        stringBuffer.append("Instance: " + this.getProductInstance() + "\n");
        logger.debug((Object)stringBuffer.toString());
        SOAPBodyElement sOAPBodyElement = this.sendEvent(this.alfEvent);
        try {
            String string = sOAPBodyElement.getAsString();
            logger.debug((Object)("Event emitted successfully, response received: " + string));
        }
        catch (Exception exception) {
            logger.error((Object)("Error processing Event return value : " + exception.getMessage()));
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getSchemaFilename() {
        return this.schemaFilename;
    }

    public void setSchemaFilename(String string) {
        this.schemaFilename = string;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String string) {
        this.serverURL = string;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int n) {
        this.waitTime = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String string) {
        this.eventId = string;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String string) {
        this.eventType = string;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String string) {
        this.objectId = string;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String string) {
        this.objectType = string;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String string) {
        this.product = string;
    }

    public String getProductInstance() {
        return this.productInstance;
    }

    public void setProductInstance(String string) {
        this.productInstance = string;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String string) {
        this.productVersion = string;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String string) {
        this.timestamp = string;
    }

    private Document loadDomEventFile() {
        Object object;
        Object object2;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setNamespaceAware(true);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        if (!this.schemaFilename.equals("")) {
            documentBuilderFactory.setValidating(false);
            object2 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            object = new File(this.schemaFilename);
            try {
                Schema schema = ((SchemaFactory)object2).newSchema((File)object);
                documentBuilderFactory.setSchema(schema);
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
        }
        object2 = null;
        object = null;
        try {
            object2 = documentBuilderFactory.newDocumentBuilder();
            ((DocumentBuilder)object2).setErrorHandler(new MyDomErrorHander());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        try {
            object = ((DocumentBuilder)object2).parse(fileInputStream);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.overrideData((Document)object);
        return object;
    }

    private void overrideData(Document document) {
        Element element = document.getDocumentElement();
        String string = element.getNamespaceURI();
        Element element2 = (Element)document.getElementsByTagNameNS(string, "Base").item(0);
        Element element3 = (Element)element2.getElementsByTagNameNS(string, "EventId").item(0);
        Element element4 = (Element)element2.getElementsByTagNameNS(string, "Timestamp").item(0);
        Element element5 = (Element)element2.getElementsByTagNameNS(string, "EventType").item(0);
        Element element6 = (Element)element2.getElementsByTagNameNS(string, "ObjectType").item(0);
        Element element7 = (Element)element2.getElementsByTagNameNS(string, "ObjectId").item(0);
        String string2 = element3.getTextContent();
        String string3 = element4.getTextContent();
        String string4 = element5.getTextContent();
        String string5 = element6.getTextContent();
        String string6 = element7.getTextContent();
        if (this.getEventId().equalsIgnoreCase("")) {
            if (string2.equalsIgnoreCase("")) {
                string2 = this.generateGUID();
                element3.setTextContent(string2);
            }
            this.setEventId(string2);
        } else {
            string2 = this.getEventId();
            element3.setTextContent(string2);
        }
        if (this.getTimestamp().equalsIgnoreCase("")) {
            if (string3.equalsIgnoreCase("")) {
                string3 = this.generateISO8601Timestamp();
                element4.setTextContent(string3);
            }
            this.setTimestamp(string3);
        } else {
            string3 = this.getTimestamp();
            element4.setTextContent(string3);
        }
        if (this.getEventType().equalsIgnoreCase("")) {
            this.setEventType(string4);
        } else {
            string4 = this.getEventType();
            element5.setTextContent(string4);
        }
        if (this.getObjectType().equalsIgnoreCase("")) {
            this.setObjectType(string5);
        } else {
            string5 = this.getObjectType();
            element6.setTextContent(string5);
        }
        if (this.getObjectId().equalsIgnoreCase("")) {
            this.setObjectId(string6);
        } else {
            string6 = this.getObjectId();
            element7.setTextContent(string6);
        }
        Element element8 = (Element)element2.getElementsByTagNameNS(string, "Source").item(0);
        Element element9 = (Element)element8.getElementsByTagNameNS(string, "Product").item(0);
        Element element10 = (Element)element8.getElementsByTagNameNS(string, "ProductVersion").item(0);
        Element element11 = (Element)element8.getElementsByTagNameNS(string, "ProductInstance").item(0);
        Element element12 = (Element)element8.getElementsByTagNameNS(string, "ProductCallbackURI").item(0);
        String string7 = element9.getTextContent();
        String string8 = element10.getTextContent();
        String string9 = element11.getTextContent();
        String string10 = element12.getTextContent();
        if (this.getProduct().equalsIgnoreCase("")) {
            this.setProduct(string7);
        } else {
            string7 = this.getProduct();
            element9.setTextContent(string7);
        }
        if (this.getProductVersion().equalsIgnoreCase("")) {
            this.setProductVersion(string8);
        } else {
            string8 = this.getProductVersion();
            element10.setTextContent(string8);
        }
        if (this.getProductInstance().equalsIgnoreCase("")) {
            this.setProductInstance(string9);
        } else {
            string9 = this.getProductInstance();
            element11.setTextContent(string9);
        }
        Element element13 = (Element)element2.getElementsByTagNameNS(string, "EventControl").item(0);
        if (element13 != null) {
            Element element14 = (Element)element13.getElementsByTagNameNS(string, "EmTimestamp").item(0);
            element14.setTextContent(string3);
            Element element15 = (Element)element13.getElementsByTagNameNS(string, "Callback").item(0);
            element15.setTextContent("false");
        }
    }

    private SOAPBodyElement loadSOAPBody() {
        Node node;
        Document document = this.loadDomEventFile();
        Element element = document.getDocumentElement();
        boolean bl = true;
        if (bl) {
            node = document.createDocumentFragment();
            Element element2 = document.createElementNS(null, "EventNotice");
            node.appendChild(element2);
            NamedNodeMap namedNodeMap = element.getAttributes();
            Node node2 = namedNodeMap.removeNamedItem("version");
            element2.setAttributeNode((Attr)node2);
            Node node3 = element.getFirstChild();
            while (node3 != null) {
                Node node4 = node3.cloneNode(true);
                element2.appendChild(node4);
                Node node5 = node3.getNextSibling();
                element.removeChild(node3);
                node3 = node5;
            }
            element.appendChild(node);
        }
        node = new SOAPBodyElement(element);
        return node;
    }

    private SOAPBodyElement sendEvent(SOAPBodyElement sOAPBodyElement) {
        SOAPBodyElement sOAPBodyElement2 = null;
        try {
            Vector vector;
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setUseSOAPAction(true);
            call.setSOAPActionURI("");
            call.setEncodingStyle(null);
            call.setProperty("sendXsiTypes", Boolean.FALSE);
            call.setProperty("sendMultiRefs", Boolean.FALSE);
            call.setSOAPVersion(SOAPConstants.SOAP11_CONSTANTS);
            call.setTargetEndpointAddress(new URL(this.serverURL));
            call.setTimeout(new Integer(this.getTimeout() * 1000));
            QName qName = new QName(WSSE_V10_NAMESPACE, WSSE_SECURITY_HEADER_ELEMENT_NAME);
            SOAPHeaderElement sOAPHeaderElement = new SOAPHeaderElement(qName);
            sOAPHeaderElement.setActor("");
            call.addHeader(sOAPHeaderElement);
            Object object = call.invoke(new Object[]{sOAPBodyElement});
            if (object != null && (vector = (Vector)object).size() > 0) {
                Object e = vector.firstElement();
                sOAPBodyElement2 = (SOAPBodyElement)e;
            }
            logger.info((Object)("EventManager invoked with a target end point address of " + this.serverURL));
        }
        catch (AxisFault axisFault) {
            logger.error((Object)("Error while invoking service " + this.serverURL + " " + axisFault.toString()));
        }
        catch (ServiceException serviceException) {
            logger.error((Object)("Error while invoking service " + this.serverURL + " " + serviceException.toString()));
        }
        catch (RemoteException remoteException) {
            logger.error((Object)("Error while invoking service " + this.serverURL + " " + remoteException.toString()));
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)("Error while invoking service " + this.serverURL + " " + malformedURLException.toString()));
        }
        return sOAPBodyElement2;
    }

    private String generateGUID() {
        return UUIDGen.nextUUID();
    }

    private String generateISO8601Timestamp() {
        Calendar calendar = Calendar.getInstance();
        TimeZone timeZone = calendar.getTimeZone();
        Long l = new Long(timeZone.getRawOffset());
        String string = l.compareTo(new Long(0L)) < 0 ? "-" : "+";
        String string2 = String.format("%1$tR", l);
        String string3 = String.format("%1$tY-%1$tm-%1$teT%1$tT%2$s%3$s", calendar, string, string2);
        return string3;
    }

    private class MyDomErrorHander
    implements ErrorHandler {
        private MyDomErrorHander() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            logger.error((Object)("Error parsing EventFile: " + sAXParseException.getMessage()));
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            logger.fatal((Object)("Error parsing EventFile: " + sAXParseException.getMessage()));
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            logger.warn((Object)("Error parsing EventFile: " + sAXParseException.getMessage()));
        }
    }
}

