/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.handler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.server.federationserver.FedSrvHelper;
import org.eclipse.alf.security.sso.server.federationserver.PageRedirector;
import org.eclipse.alf.security.sso.server.federationserver.RequestContext;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.handler.CancelRequestHandler;
import org.eclipse.alf.security.sso.server.federationserver.handler.CredentialsHandler;
import org.eclipse.alf.security.sso.server.federationserver.handler.InboundWSFedHandler;
import org.eclipse.alf.security.sso.server.federationserver.handler.InboundWSTrustHandler;
import org.eclipse.alf.security.sso.server.federationserver.handler.IssueRequestHandler;
import org.eclipse.alf.security.sso.server.federationserver.handler.MasterCookieHandler;
import org.eclipse.alf.security.sso.server.federationserver.handler.RemoteDataRequestHandler;

public class RequestDispatcher {
    private static final Logger log = Logger.getLogger(RequestDispatcher.class);

    public static void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        RemoteDataRequestHandler remoteDataRequestHandler;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering the WS-Federation Request Dispatcher");
        }
        if ((remoteDataRequestHandler = new RemoteDataRequestHandler()).isValidRemoteDataRequest(req)) {
            remoteDataRequestHandler.serveRequest(req, resp);
            return;
        }
        RequestContext requestContext = RequestDispatcher.createRequestContext(req, resp);
        if (requestContext == null) {
            return;
        }
        if (requestContext.isIssueRequest()) {
            if (!CredentialsHandler.process(req, resp, requestContext)) {
                return;
            }
            if (!IssueRequestHandler.serveIssueRequest(req, resp, requestContext)) {
                return;
            }
            PageRedirector.redrectBack(req, resp, requestContext);
            return;
        }
        if (requestContext.isCancelRequest()) {
            if (!CancelRequestHandler.serveCancelRequest(req, resp, requestContext)) {
                return;
            }
            PageRedirector.redirectToLogoutPage(req, resp, requestContext);
        }
    }

    private static RequestContext getRequestContextFromSession(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        return (RequestContext)req.getSession().getAttribute("ATTR_REQUEST_CONTEXT");
    }

    private static RequestContext createRequestContext(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        RequestContext requestContext = null;
        RequestContext sessionRequestContext = RequestDispatcher.getRequestContextFromSession(req, resp);
        if (sessionRequestContext != null) {
            requestContext = sessionRequestContext;
            req.getSession().removeAttribute("ATTR_REQUEST_CONTEXT");
            if (FedSrvHelper.isValidWSFedRequest(req, resp)) {
                requestContext = new RequestContext();
                sessionRequestContext = null;
                req.getSession().invalidate();
            }
        } else {
            requestContext = new RequestContext();
        }
        if (sessionRequestContext == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Handling WS-Federation intial request");
            }
            requestContext.setRpConfig(FedSrvConfig.getInstance().getDefaultRPConfig());
            if (!InboundWSFedHandler.processRequest(req, resp, requestContext)) {
                return null;
            }
            if (!InboundWSTrustHandler.processRequest(req, resp, requestContext)) {
                return null;
            }
            if (!requestContext.getMasterCookieQueried()) {
                MasterCookieHandler.queryMasterCookie(req, resp, requestContext);
            }
            PageRedirector.redirectRemoveParams(req, resp, requestContext);
            return null;
        }
        return requestContext;
    }
}

