/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.processor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.EscapeCharHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataObjectFactory;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataStorage;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTCallProxy;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecurityContext;
import org.eclipse.alf.security.sso.common.ws.message.trust.cancel.RSTCancelRequest;
import org.eclipse.alf.security.sso.common.ws.message.trust.cancel.RSTRCancelValidationResult;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectFactory;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityTokenResponse;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedTokenCancelled;
import org.eclipse.alf.security.sso.server.federationserver.ProcessingException;
import org.eclipse.alf.security.sso.server.federationserver.RequestContext;
import org.eclipse.alf.security.sso.server.federationserver.processor.AbstractRequestProcessor;
import org.eclipse.alf.security.sso.server.federationserver.processor.RequestProcessorResult;
import org.eclipse.alf.security.sso.server.federationserver.secctx.SecCtxLogonAppToSTS;

public class CancelRequestProcessor
extends AbstractRequestProcessor {
    private static final Logger log = Logger.getLogger(CancelRequestProcessor.class);

    public RequestProcessorResult process(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext) throws ProcessingException {
        RSTRCancelValidationResult validationResult;
        RequestProcessorResult retVal = new RequestProcessorResult();
        WSFedData outboundWSFedData = WSFedDataObjectFactory.createWSFedData();
        outboundWSFedData.copyDeep(requestContext.getInboundWsfData());
        RequestSecurityTokenResponse rstr = null;
        RSTCallProxy callProxy = null;
        try {
            callProxy = new RSTCallProxy(requestContext.getRpConfig().getCoreConfig().getAxis2ConfigurationContext());
        }
        catch (SSOException e) {
            // empty catch block
        }
        if (callProxy == null) {
            retVal.setCode(2);
            retVal.setMessage("Failed to create SOAP call proxy");
            return retVal;
        }
        RSTCancelRequest request = new RSTCancelRequest();
        request.setEpr(requestContext.getRpConfig().getCoreConfig().getParameter("SecurityTokenService"));
        request.setRawRST(requestContext.getRSTElement());
        try {
            SecCtxLogonAppToSTS securityContext = new SecCtxLogonAppToSTS();
            request.setSecurityContext((SecurityContext)securityContext);
            rstr = requestContext.rstr;
            validationResult = new RSTRCancelValidationResult();
            if (rstr == null) {
                WSTrustObjectFactory fac = WSAbstractFactory.getWSTObjectFactory();
                rstr = fac.createRequestSecurityTokenResponse();
                RequestedTokenCancelled cancelConfirmation = fac.createRequestedTokenCancelled();
                rstr.setRequestedTokenCancelled(cancelConfirmation);
                requestContext.rstr = rstr;
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Axis fault caught while issuing a SOAP call", (Throwable)e);
            retVal.setCode(1);
            retVal.setMessage(e.getMessage());
            return retVal;
        }
        catch (SSOException e) {
            log.error((Object)"SSO exception while issuing a SOAP call to STS.", (Throwable)e);
            retVal.setCode(2);
            retVal.setMessage(e.getMessage());
            return retVal;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validated Cancel RSTR:" + validationResult.getCode()));
        }
        if (!validationResult.isSuccess()) {
            log.error((Object)("RSTR validation failed with code:" + validationResult.getCode()));
            throw new ProcessingException("RSTR validation failed");
        }
        String wresult = rstr.toString();
        boolean forceRemoteData = requestContext.getRpConfig().getCoreConfig().getBooleanParameter("ForceRemoteDataInWSFederation", false);
        if (forceRemoteData) {
            log.debug((Object)"Returning result via remote data pattern");
            outboundWSFedData.setWresult(wresult);
            long remoteDataTTL = requestContext.getRpConfig().getCoreConfig().getLongParameter("RemoteDataTTL", 60L);
            RemoteDataStorage rd = RemoteDataStorage.getInstance();
            String rdKey = rd.add((Object)outboundWSFedData.getWresult(), remoteDataTTL);
            String remoteDataURL = requestContext.getRpConfig().getCoreConfig().getRemoteDataURL(req.getRequestURL().toString(), req.getServerPort());
            outboundWSFedData = WSFedHelper.convertWresultToWresultptr((String)remoteDataURL, (String)rdKey, (WSFedData)outboundWSFedData);
        } else {
            log.debug((Object)"Returning result directly in POST form");
            outboundWSFedData.setWresult(EscapeCharHelper.forHTMLTag((String)wresult));
            outboundWSFedData.setWresult(wresult);
        }
        requestContext.setOutboundWsfData(outboundWSFedData);
        return retVal;
    }
}

