/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.cookie.CookieData;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.token.SSOTokenPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataObjectFactory;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.Address;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.EndpointReference;
import org.eclipse.alf.security.sso.common.ws.model.policy.element.AppliesTo;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityToken;
import org.eclipse.alf.security.sso.server.federationserver.RequestContext;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;

public class FedSrvHelper {
    private static final Logger log = Logger.getLogger(FedSrvHelper.class);

    public static CookieData extractALFSSOCookieData(HttpServletRequest req, FedSrvRPConfig rpConfig, String rpType, String rpRealm, ArrayList cookieObjects) {
        CookieData cookieData = null;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cookies were found.");
            }
            String remoteUserIP = req.getRemoteAddr();
            try {
                cookieData = rpConfig.getCoreConfig().getCookieManager().getBindCookiesToUserIP() ? rpConfig.getCoreConfig().getCookieManager().getCookie(cookies, rpType, rpRealm, remoteUserIP, cookieObjects) : rpConfig.getCoreConfig().getCookieManager().getCookie(cookies, rpType, rpRealm, null, cookieObjects);
            }
            catch (SSOException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Error while finding cookie for:" + rpType + ":" + rpRealm));
                }
                return null;
            }
        }
        if (cookieData != null) {
            SSOToken token = cookieData.getToken();
            SAML1Policy tokenProfilePolicy = rpConfig.getTokenPolicy();
            token.setValidationPolicy((SSOTokenPolicy)tokenProfilePolicy);
        }
        return cookieData;
    }

    public static SSOToken extractTokenFromHTTPHeader(HttpServletRequest req, RequestContext requestContext) {
        SSOToken token;
        block6: {
            String tokenString = null;
            token = null;
            if (req.getHeader("ALFSSOAuthNToken") != null) {
                tokenString = req.getHeader("ALFSSOAuthNToken");
            }
            if (StringHelper.isNotBlank(tokenString)) {
                tokenString = tokenString.trim();
                try {
                    token = SSOTokenFactory.createSSOToken((String)tokenString);
                    if (token == null) {
                        log.debug((Object)"Error creating SSO token object from header content");
                        break block6;
                    }
                    token.setValidationPolicy((SSOTokenPolicy)requestContext.getRpConfig().getTokenPolicy());
                }
                catch (SSOException e) {
                    log.info((Object)"Error processing security token", (Throwable)e);
                }
            } else {
                log.warn((Object)"ALF SSO header found on request but no content in it");
            }
        }
        return token;
    }

    public static String extractAppliesToStringFromRST(RequestSecurityToken rst) {
        String retVal = null;
        if (rst == null) {
            return null;
        }
        AppliesTo appliesToObj = rst.getAppliesTo();
        if (appliesToObj != null) {
            List knownObjList = appliesToObj.getKnownObjectsList();
            if (knownObjList != null && knownObjList.size() == 1) {
                EndpointReference eprObj = null;
                Address addr = null;
                if (knownObjList.get(0) instanceof EndpointReference) {
                    eprObj = (EndpointReference)knownObjList.get(0);
                    if (eprObj != null) {
                        addr = eprObj.getAddress();
                    }
                } else if (knownObjList.get(0) instanceof Address) {
                    addr = (Address)knownObjList.get(0);
                }
                if (addr != null) {
                    retVal = addr.getAddress();
                }
            }
        } else if (rst.getCancelTarget() != null && rst.getCancelTarget().getSecurityToken() != null) {
            try {
                SSOToken token = SSOTokenFactory.createSSOToken((Object)rst.getCancelTarget().getSecurityToken().getNativeObject());
                String[] tokenTargetRelyingParties = token.getTargetRelyingParties();
                retVal = tokenTargetRelyingParties.length == 0 ? null : tokenTargetRelyingParties[0];
            }
            catch (SSOException sSOException) {
                // empty catch block
            }
        }
        return retVal;
    }

    public static boolean isValidWSFedRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        WSFedData wsfData = WSFedHelper.getWSFDataFromRequestParameters((HttpServletRequest)req);
        ExtendedResult wsfValidationResult = WSFedDataObjectFactory.createWSFedDataValidator().validateRequest(wsfData);
        return wsfValidationResult.isSuccess();
    }

    public static String getLocalizedMessage(String key, Locale locale) {
        String errorMessage = "Failed to retrieve localized message";
        try {
            ResourceBundle rb = ResourceBundle.getBundle("i18n/ALFSSOI18N", locale);
            if (rb != null && (errorMessage = (String)rb.getObject(key)) == null) {
                errorMessage = "Failed to retrieve localized message";
            }
        }
        catch (MissingResourceException e) {
            log.error((Object)("Failed to retrieve localized message from i18n/ALFSSOI18N with key " + key));
        }
        return errorMessage;
    }
}

