/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.handler;

import java.text.MessageFormat;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.server.federationserver.FedSrvHelper;
import org.eclipse.alf.security.sso.server.federationserver.PageRedirector;
import org.eclipse.alf.security.sso.server.federationserver.ProcessingException;
import org.eclipse.alf.security.sso.server.federationserver.RequestContext;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.IssuedTokensData;
import org.eclipse.alf.security.sso.server.federationserver.processor.IssueRequestProcessor;
import org.eclipse.alf.security.sso.server.federationserver.processor.RequestProcessorResult;

public class IssueRequestHandler {
    static final Logger log = Logger.getLogger(IssueRequestHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean serveIssueRequest(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext) throws ServletException {
        ArrayList<IssuedTokensData> authenticatedEntries;
        log.info((Object)("Processing a RST/Issue request for " + requestContext.getAppliesToURI()));
        IssueRequestProcessor issueProcessor = new IssueRequestProcessor();
        RequestProcessorResult result = null;
        try {
            result = issueProcessor.process(req, resp, requestContext);
        }
        catch (ProcessingException e) {
            log.error((Object)("Error processing issue request: " + e.getMessage()));
            String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.issue.errorProcessingIssueRequest", req.getLocale());
            PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
            return false;
        }
        if (!result.isSuccess()) {
            log.error((Object)("Error acquiring security token: " + result.getMessage()));
            String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.issue.errorAcuiringSecurityToken", req.getLocale());
            localizedError = MessageFormat.format(localizedError, result.getMessage());
            PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
            return false;
        }
        IssuedTokensData data = new IssuedTokensData(requestContext.getIssuedToken(), requestContext.getInboundWsfData().getWreply(), requestContext.getRpConfig());
        String key = requestContext.getIssuedToken().getId();
        long timeToLiveInSecods = 0L;
        if (System.currentTimeMillis() < requestContext.getIssuedToken().getNotOnOrAfter().getTime()) {
            timeToLiveInSecods = (requestContext.getIssuedToken().getNotOnOrAfter().getTime() - System.currentTimeMillis()) / 1000L;
        }
        if ((authenticatedEntries = (ArrayList<IssuedTokensData>)FedSrvConfig.getInstance().getIssuedTokens().get((Object)key)) == null) {
            authenticatedEntries = new ArrayList<IssuedTokensData>();
            authenticatedEntries.add(data);
            FedSrvConfig.getInstance().getIssuedTokens().put((Object)key, authenticatedEntries, timeToLiveInSecods);
        } else {
            ArrayList<IssuedTokensData> arrayList = authenticatedEntries;
            synchronized (arrayList) {
                authenticatedEntries.add(data);
            }
        }
        return true;
    }
}

