/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventmapeditor.wizards;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class EventMapWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private ISelection selection;

    public EventMapWizardPage(ISelection iSelection) {
        super("wizardPage");
        this.setTitle(" Create Event-Action Map File");
        this.setDescription("This wizard creates a new Event-Action Map file with *.alf extension that can be opened by Event Map Editor.");
        this.selection = iSelection;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 9;
        Label label = new Label(composite2, 0);
        label.setText("&Container:");
        this.containerText = new Text(composite2, 2052);
        GridData gridData = new GridData(768);
        this.containerText.setLayoutData((Object)gridData);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EventMapWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(composite2, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EventMapWizardPage.this.handleBrowse();
            }
        });
        label = new Label(composite2, 0);
        label.setText("&ApplicationName:");
        this.fileText = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.fileText.setLayoutData((Object)gridData);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EventMapWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)composite2);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.selection;
            if (iStructuredSelection.size() > 1) {
                return;
            }
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IResource) {
                IContainer iContainer = object instanceof IContainer ? (IContainer)object : ((IResource)object).getParent();
                this.containerText.setText(iContainer.getFullPath().toString());
            }
        }
        this.fileText.setText("ApplicationName.alf");
    }

    private void handleBrowse() {
        Object[] objectArray;
        ContainerSelectionDialog containerSelectionDialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (containerSelectionDialog.open() == 0 && (objectArray = containerSelectionDialog.getResult()).length == 1) {
            this.containerText.setText(((Path)objectArray[0]).toString());
        }
    }

    private void dialogChanged() {
        Object object;
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String string = this.getFileName();
        if (iResource == null && this.getContainerName().trim().length() > 0) {
            this.updateStatus("Project does not exist");
            return;
        }
        if (this.getContainerName().trim().length() == 0 || (iResource.getType() & 6) == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (string.length() > 0) {
            IContainer iContainer = (IContainer)iResource;
            try {
                object = iContainer.members();
                for (int i = 0; i < ((IResource[])object).length; ++i) {
                    if (!string.equalsIgnoreCase(object[i].getName())) continue;
                    this.updateStatus("File already exist");
                    return;
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        if (string.length() > 120) {
            this.updateStatus("Event Action Map File name should not exceeds 120 characters.");
            return;
        }
        if (!iResource.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (string.trim().length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (string.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        int n = string.lastIndexOf(46);
        if (n != -1 && !((String)(object = string.substring(n + 1))).equalsIgnoreCase("alf")) {
            this.updateStatus("File extension must be \"alf\"");
            return;
        }
        boolean bl = false;
        Pattern pattern = Pattern.compile("^[A-Za-z0-9\\.\\s_-]+$");
        Matcher matcher = pattern.matcher(this.getFileName());
        bl = matcher.matches();
        if (!bl) {
            this.updateStatus(" Not a valid application name. Special characters not allowed.");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public void setContainerName(Text text) {
        this.containerText = text;
    }

    public void setFileName(Text text) {
        this.fileText = text;
    }
}

