/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.models;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class RegisteredEvent {
    private String eventType;
    private String objectType;
    private String product;
    private String productVersion;
    private String productInstance;
    private String eventMatchName;

    public static RegisteredEvent[] loadEventRegistryXML(Composite composite, File file) throws IOException {
        RegisteredEvent[] registeredEventArray = null;
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = null;
            document = file.exists() ? sAXBuilder.build(file) : new Document(new Element("ALFEventRegistry"));
            if (document.getRootElement() == null) {
                throw new JDOMException();
            }
            Element element = document.getRootElement();
            Namespace namespace = element.getNamespace();
            List list = element.getChildren("Event", element.getNamespace());
            registeredEventArray = new RegisteredEvent[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                registeredEventArray[i] = new RegisteredEvent();
                Element element2 = (Element)list.get(i);
                registeredEventArray[i].eventType = element2.getChildText("EventType", namespace);
                registeredEventArray[i].objectType = element2.getChildText("ObjectType", namespace);
                registeredEventArray[i].product = element2.getChildText("Product", namespace);
                registeredEventArray[i].productVersion = element2.getChildText("ProductVersion", namespace);
                registeredEventArray[i].productInstance = element2.getChildText("ProductInstance", namespace);
                registeredEventArray[i].eventMatchName = element2.getChildText("EventMatchName", namespace);
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (JDOMException jDOMException) {
            MessageBox messageBox = new MessageBox(composite.getShell(), 1);
            messageBox.setMessage("ALF Event Registry XML is not Valid  . " + jDOMException.getMessage());
            messageBox.setText("ALF Events Registry ");
            messageBox.open();
        }
        return registeredEventArray;
    }

    public static void saveEventRegistryXML(RegisteredEvent[] registeredEventArray, File file) throws Exception {
        try {
            Namespace namespace = Namespace.getNamespace((String)"p", (String)"http://www.eclipse.org/ALF/XMLSchema/EventRule");
            Namespace namespace2 = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
            String string = "xsi:schemaLocation=http://www.eclipse.org/ALF/XMLSchema/EventRule EventActionMap.xsd";
            Namespace.getNamespace((String)string);
            Element element = new Element("ALFEventRegistry");
            Document document = new Document(element);
            for (int i = 0; i < registeredEventArray.length; ++i) {
                Element element2 = new Element("Event");
                element.addNamespaceDeclaration(namespace);
                element.addNamespaceDeclaration(namespace2);
                element2.addContent((Content)new Element("EventType").addContent(registeredEventArray[i].eventType));
                element2.addContent((Content)new Element("ObjectType").addContent(registeredEventArray[i].objectType));
                element2.addContent((Content)new Element("Product").addContent(registeredEventArray[i].product));
                element2.addContent((Content)new Element("ProductVersion").addContent(registeredEventArray[i].productVersion));
                element2.addContent((Content)new Element("ProductInstance").addContent(registeredEventArray[i].productInstance));
                element2.addContent((Content)new Element("EventMatchName").addContent(registeredEventArray[i].eventMatchName));
                element.addContent((Content)element2);
            }
            XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
            xMLOutputter.output(document, (OutputStream)new FileOutputStream(file));
        }
        catch (Exception exception) {
            throw new Exception("ALFEvent Registry XML is not Valid", exception);
        }
    }

    public static void readBasicEventTypes(File file, ArrayList arrayList, ArrayList arrayList2) {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(file);
            Namespace namespace = Namespace.getNamespace((String)"xs", (String)"http://www.w3.org/2001/XMLSchema");
            Element element = document.getRootElement();
            List list = element.getChildren();
            for (Element element2 : list) {
                List list2;
                List list3;
                String string = element2.getAttributeValue("name");
                if (string.equals("EventTypeType")) {
                    list3 = element2.getChildren("restriction", namespace);
                    for (Element element3 : list3) {
                        list2 = element3.getChildren("enumeration", namespace);
                        for (Element element4 : list2) {
                            arrayList.add(element4.getAttributeValue("value"));
                        }
                    }
                }
                if (!(string = element2.getAttributeValue("name")).equals("ObjectTypeType")) continue;
                list3 = element2.getChildren("restriction", namespace);
                for (Element element3 : list3) {
                    list2 = element3.getChildren("enumeration", namespace);
                    for (Element element4 : list2) {
                        arrayList2.add(element4.getAttributeValue("value"));
                    }
                }
            }
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String string) {
        this.eventType = string;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String string) {
        this.objectType = string;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String string) {
        this.product = string;
    }

    public String getProductInstance() {
        return this.productInstance;
    }

    public void setProductInstance(String string) {
        this.productInstance = string;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String string) {
        this.productVersion = string;
    }

    public String getEventMatchName() {
        return this.eventMatchName;
    }

    public void setEventMatchName(String string) {
        this.eventMatchName = string;
    }
}

