/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.matcher.builder;

import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.AbstractMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.RPURIMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.builder.AbstractMatcherBuilder;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;

public class RPURIMatcherBuilder
extends AbstractMatcherBuilder {
    private static final Logger log = Logger.getLogger(RPURIMatcherBuilder.class);
    public static final String RPURI_MATCHER_LN = "RPURIMatcher";
    public static final String TYPE_LN = "Type";
    public static final String REALM_LN = "Realm";
    public static final String INSTANCE_LN = "Instance";

    public RPURIMatcherBuilder() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public String getLocalName() {
        return RPURI_MATCHER_LN;
    }

    public AbstractMatcher build(OMElement element) throws SSOException {
        String instance;
        String realm;
        if (element == null) {
            return null;
        }
        if (!element.getLocalName().equals(this.getLocalName())) {
            return null;
        }
        String comparer = XMLHelper.getAttribute(element, "comparer");
        RPURIMatcher rpuriMatcher = StringHelper.isBlank(comparer) ? new RPURIMatcher(1) : (comparer.equals("basic") ? new RPURIMatcher(1) : (comparer.equals("regex") ? new RPURIMatcher(2) : new RPURIMatcher(1)));
        String type = XMLHelper.getAttribute(element, TYPE_LN);
        if (type == null && log.isDebugEnabled()) {
            log.debug((Object)"@Type attribute not found, assuming (*) as regex expression");
        }
        if ((realm = XMLHelper.getAttribute(element, REALM_LN)) == null && log.isDebugEnabled()) {
            log.debug((Object)"@Realm attribute not found, assuming (*) as regex expression");
        }
        if ((instance = XMLHelper.getAttribute(element, INSTANCE_LN)) == null && log.isDebugEnabled()) {
            log.debug((Object)"@Instance attribute not found, assuming (*) as regex expression");
        }
        rpuriMatcher.setRegexType(type);
        rpuriMatcher.setRegexRealm(realm);
        rpuriMatcher.setRegexInstance(instance);
        return rpuriMatcher;
    }
}

