/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.builder;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.ClaimPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.ClaimsPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.BasePolicyBuilder;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.ClaimPolicyBuilder;
import org.eclipse.alf.security.sso.common.util.SSOHelper;

public class ClaimsPolicyBuilder
extends BasePolicyBuilder {
    private static final Logger log = Logger.getLogger(ClaimsPolicyBuilder.class);
    public static final String CLAIMS_POLICY_LN = "ClaimsPolicy";

    public String getLocalName() {
        return CLAIMS_POLICY_LN;
    }

    public BasePolicy build(OMElement element) throws SSOException {
        return this.build(element, null);
    }

    public BasePolicy build(OMElement element, BasePolicy base) throws SSOException {
        if (element == null) {
            log.warn((Object)"ClaimsPolicyBuilder.build(null) called");
            return base;
        }
        OMElement el = element.getFirstChildWithName(new QName(this.getLocalName()));
        if (el == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ClaimsPolicyBuilder.build(): policy local name not found");
            }
            return base;
        }
        ClaimsPolicy claimsPolicy = new ClaimsPolicy();
        claimsPolicy = base != null ? (ClaimsPolicy)base.clone() : new ClaimsPolicy();
        if (SSOHelper.toBoolean(this.getAttribute(el, "override"), claimsPolicy.getOverride())) {
            log.debug((Object)"ClaimsPolicyBuilder.build(): Overriding previously defined policy");
            claimsPolicy = new ClaimsPolicy();
        }
        claimsPolicy.setEnforced(SSOHelper.toBoolean(this.getAttribute(el, "enforce"), claimsPolicy.getEnforced()));
        ClaimPolicyBuilder claimPolicyBuilder = new ClaimPolicyBuilder();
        Iterator claimPoliciesIt = el.getChildrenWithName(new QName(claimPolicyBuilder.getLocalName()));
        if (claimPoliciesIt != null) {
            while (claimPoliciesIt.hasNext()) {
                OMElement next = (OMElement)claimPoliciesIt.next();
                ClaimPolicy claimPolicy = (ClaimPolicy)claimPolicyBuilder.build(next);
                if (claimPolicy != null) {
                    claimsPolicy.addClaimPolicy(claimPolicy);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Error building <" + this.getLocalName() + "> element: failed to build claim policy object"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("<" + this.getLocalName() + "> element is missing claim polices"));
        }
        return claimsPolicy;
    }
}

