/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.federation.passive;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.EscapeCharHelper;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataObjectFactory;

public class WSFedHelper {
    private static final Logger log = Logger.getLogger(WSFedHelper.class);

    public static WSFedData getWSFDataFromRequestParameters(HttpServletRequest req) {
        WSFedData wsfData = WSFedDataObjectFactory.createWSFedData();
        Iterator reqParams = wsfData.getParamNames();
        while (reqParams != null && reqParams.hasNext()) {
            String paramName = (String)reqParams.next();
            String paramValue = req.getParameter(paramName);
            wsfData.set(paramName, paramValue);
        }
        return wsfData;
    }

    public static WSFedData getWSFDataFromRequestAttributes(HttpServletRequest req) {
        WSFedData wsfData = WSFedDataObjectFactory.createWSFedData();
        Iterator reqParams = wsfData.getParamNames();
        while (reqParams != null && reqParams.hasNext()) {
            String paramName = (String)reqParams.next();
            String paramValue = (String)req.getAttribute(paramName);
            wsfData.set(paramName, paramValue);
        }
        return wsfData;
    }

    public static boolean setWSFDataAsAttributes(HttpServletRequest req, WSFedData wsfData) {
        if (wsfData == null || wsfData.isEmpty()) {
            log.error((Object)"Invalid arguments: WSFData cannot be null or empty");
            return false;
        }
        Iterator reqParamsIt = wsfData.getRequestParamNames();
        while (reqParamsIt.hasNext()) {
            String paramName = (String)reqParamsIt.next();
            String paramValue = wsfData.get(paramName);
            if (!StringHelper.isNotBlank(paramValue)) continue;
            req.setAttribute(paramName, (Object)paramValue);
        }
        Iterator respParamsIt = wsfData.getResponseParamNames();
        while (respParamsIt.hasNext()) {
            String paramName = (String)respParamsIt.next();
            String paramValue = wsfData.get(paramName);
            if (!StringHelper.isNotBlank(paramValue)) continue;
            req.setAttribute(paramName, (Object)paramValue);
        }
        return true;
    }

    public static void printHTMLFormInputs(WSFedData wsfData, PrintWriter writer) {
        if (StringHelper.isNotBlank(wsfData.getWa())) {
            writer.println("<input type=\"hidden\" name=\"wa\" value=\"" + EscapeCharHelper.forHTMLTag(wsfData.getWa()) + "\" />");
        }
        if (StringHelper.isNotBlank(wsfData.getWattr())) {
            writer.println("<input type=\"hidden\" name=\"wattr\" value=\"" + EscapeCharHelper.forHTMLTag(wsfData.getWattr()) + "\"/>");
        }
        if (StringHelper.isNotBlank(wsfData.getWct())) {
            writer.println("<input type=\"hidden\" name=\"wct\" value=\"" + EscapeCharHelper.forHTMLTag(wsfData.getWct()) + "\"/>");
        }
        if (StringHelper.isNotBlank(wsfData.getWctx())) {
            writer.println("<input type=\"hidden\" name=\"wctx\" value=\"" + EscapeCharHelper.forHTMLTag(wsfData.getWctx()) + "\"/>");
        }
        if (StringHelper.isNotBlank(wsfData.getWp())) {
            writer.println("<input type=\"hidden\" name=\"wp\" value=\"" + EscapeCharHelper.forHTMLTag(wsfData.getWp()) + "\" />");
        }
        if (StringHelper.isNotBlank(wsfData.getWpseudo())) {
            writer.println("<input type=\"hidden\" name=\"wpseudo\" value=\"" + EscapeCharHelper.forHTMLTag(wsfData.getWpseudo()) + "\" />");
        }
        if (StringHelper.isNotBlank(wsfData.getWreply())) {
            writer.println("<input type=\"hidden\" name=\"wreply\" value=\"" + EscapeCharHelper.forHTMLTag(wsfData.getWreply()) + "\"/>");
        }
        if (StringHelper.isNotBlank(wsfData.getWreq())) {
            writer.println("<input type=\"hidden\" name=\"wreq\" value=\"" + EscapeCharHelper.forHTMLTag(wsfData.getWreq()) + "\"/>");
        }
        if (StringHelper.isNotBlank(wsfData.getWreqptr())) {
            writer.println("<input type=\"hidden\" name=\"wreqptr\" value=\"" + EscapeCharHelper.forHTMLTag(wsfData.getWreqptr()) + "\"/>");
        }
        if (StringHelper.isNotBlank(wsfData.getWres())) {
            writer.println("<input type=\"hidden\" name=\"wres\" value=\"" + EscapeCharHelper.forHTMLTag(wsfData.getWres()) + "\"/>");
        }
        if (StringHelper.isNotBlank(wsfData.getWresult())) {
            writer.println("<input type=\"hidden\" name=\"wresult\" value=\"" + EscapeCharHelper.forHTMLTag(wsfData.getWresult()) + "\"/>");
        }
        if (StringHelper.isNotBlank(wsfData.getWresultptr())) {
            writer.println("<input type=\"hidden\" name=\"wresultptr\" value=\"" + EscapeCharHelper.forHTMLTag(wsfData.getWresultptr()) + "\"/>");
        }
        if (StringHelper.isNotBlank(wsfData.getWtrealm())) {
            writer.println("<input type=\"hidden\" name=\"wtrealm\" value=\"" + EscapeCharHelper.forHTMLTag(wsfData.getWtrealm()) + "\"/>");
        }
    }

    public static String generateRedirectURL(String targetURL, WSFedData wsfData) {
        return WSFedHelper.abstractGenerateRedirectURL(targetURL, wsfData, wsfData.getRequestParamNames());
    }

    public static String generateResponseRedirectURL(String targetURL, WSFedData wsfData) {
        return WSFedHelper.abstractGenerateRedirectURL(targetURL, wsfData, wsfData.getResponseParamNames());
    }

    private static String abstractGenerateRedirectURL(String targetURL, WSFedData wsfData, Iterator paramNames) {
        if (wsfData == null || targetURL == null || targetURL.trim().length() == 0) {
            log.error((Object)"Invalid arguments");
            return null;
        }
        try {
            StringBuffer sb = new StringBuffer();
            Iterator reqParams = paramNames;
            if (reqParams == null) {
                log.error((Object)("wsf validation failed:" + wsfData.toString()));
                return null;
            }
            while (reqParams.hasNext()) {
                String paramName = (String)reqParams.next();
                String paramValue = wsfData.get(paramName);
                if (paramValue == null) continue;
                try {
                    paramValue = URLEncoder.encode(paramValue, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)"Unsupported encoding caught", (Throwable)e);
                    return null;
                }
                sb.append('&');
                sb.append(paramName);
                sb.append('=');
                sb.append(paramValue);
            }
            if (sb.length() == 0) {
                log.error((Object)"No response parameters");
                throw new SSOException("No response parameters");
            }
            return targetURL + "?" + sb.toString().substring(1);
        }
        catch (Throwable e) {
            log.error((Object)"Generating redirect URL", e);
            return null;
        }
    }

    public static WSFedData convertWreqToWreqptr(String requestURL, String key, WSFedData wsfData) {
        URL url = null;
        if (requestURL == null || requestURL.trim().length() == 0 || key == null || key.trim().length() == 0 || wsfData == null) {
            log.error((Object)"Invalid argument");
            return null;
        }
        try {
            url = new URL(requestURL);
            if (url.getQuery() == null) {
                wsfData.setWreqptr(url.toString() + "?" + "wsfrdreq" + "=" + key);
            } else {
                wsfData.setWreqptr(url.toString() + "&" + "wsfrdreq" + "=" + key);
            }
            wsfData.setWreq(null);
        }
        catch (MalformedURLException e) {
            log.error((Object)("Invalid argument URL: " + requestURL));
            return null;
        }
        return wsfData;
    }

    public static WSFedData convertWresultToWresultptr(String requestURL, String key, WSFedData wsfData) {
        URL url = null;
        if (requestURL == null || requestURL.trim().length() == 0 || key == null || key.trim().length() == 0 || wsfData == null) {
            log.error((Object)"Invalid argument");
            return null;
        }
        try {
            url = new URL(requestURL);
            if (url.getQuery() == null) {
                wsfData.setWresultptr(url.toString() + "?" + "wsfrdreq" + "=" + key);
            } else {
                wsfData.setWresultptr(url.toString() + "&" + "wsfrdreq" + "=" + key);
            }
            wsfData.setWresult(null);
        }
        catch (MalformedURLException e) {
            log.error((Object)("Invalid argument URL: " + requestURL));
            return null;
        }
        return wsfData;
    }

    public static Hashtable getParamsFromURL(String url) {
        StringTokenizer st = new StringTokenizer(url, "?&=", true);
        String previous = null;
        Hashtable<String, String> params = new Hashtable<String, String>();
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            if ("?".equals(current) || "&".equals(current)) continue;
            if ("=".equals(current)) {
                params.put(previous, st.nextToken());
                continue;
            }
            previous = current;
        }
        return params;
    }

    public static WSFedData generateWSFSignOutRequestData(String replyURL, String context, String request, String realm) {
        WSFedData wsfData = WSFedDataObjectFactory.createWSFedData();
        wsfData.setWa("wsignout1.0");
        wsfData.setWct(SSOHelper.nowInZuluTime());
        wsfData.setWreply(replyURL);
        wsfData.setWctx(context);
        wsfData.setWreq(request);
        wsfData.setWtrealm(realm);
        return wsfData;
    }

    public static WSFedData generateWSFSignInRequestData(String replyURL, String context, String request, String realm) {
        WSFedData wsfData = WSFedDataObjectFactory.createWSFedData();
        wsfData.setWa("wsignin1.0");
        wsfData.setWct(SSOHelper.nowInZuluTime());
        wsfData.setWreply(replyURL);
        wsfData.setWctx(context);
        wsfData.setWreq(request);
        wsfData.setWtrealm(realm);
        return wsfData;
    }

    public static String createContextString(String key, String uuid) {
        return key + ":" + uuid.hashCode();
    }

    public static String getKeyFromContext(String ctx) {
        if (ctx == null) {
            return null;
        }
        int sepidx = ctx.indexOf(58);
        if (sepidx == -1) {
            return null;
        }
        String maxsize = new Long(Long.MAX_VALUE).toString();
        if (sepidx > maxsize.length() + 1) {
            return null;
        }
        return ctx.substring(0, sepidx);
    }

    public static boolean isValidContextHash(String ctx, String uuid) {
        long hash2;
        if (uuid == null) {
            return false;
        }
        if (ctx == null) {
            return false;
        }
        int sepidx = ctx.indexOf(58);
        if (sepidx == -1) {
            return false;
        }
        String maxsize = new Long(Long.MAX_VALUE).toString();
        int len = ctx.length() - sepidx;
        if (len < 1 && len > maxsize.length() + 1) {
            return false;
        }
        String hashFromCtxString = ctx.substring(sepidx + 1, ctx.length());
        if (hashFromCtxString == null) {
            return false;
        }
        long hash1 = uuid.hashCode();
        return hash1 == (hash2 = new Long(hashFromCtxString).longValue());
    }

    public static boolean isRequestDataRemoted(WSFedData wsfData) {
        boolean retVal = wsfData.getWreq() == null && wsfData.getWreqptr() != null && wsfData.getWreqptr().trim().length() > 0;
        return retVal;
    }
}

