/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl;

import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSObject;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExt;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExtVersion;

public abstract class BaseWSSecExtObjectImpl
extends BaseWSObject
implements BaseWSInterface {
    static final Logger log = Logger.getLogger(BaseWSSecExtObjectImpl.class);

    public boolean baseIsCompatibleElement(OMElement element, String expectedLocalName) throws SSOException {
        throw new SSOException("This method should never be called");
    }

    public WSSecExt baseIsCompatibleElementSecExt(OMElement element, String expectedLocalName) throws SSOException {
        if (element == null) {
            return null;
        }
        String localName = element.getLocalName();
        String wsseNSURI = null;
        if (element.getNamespace() == null) {
            if (element.getDefaultNamespace() == null) {
                return null;
            }
            wsseNSURI = element.getDefaultNamespace().getNamespaceURI();
        } else {
            wsseNSURI = element.getNamespace().getNamespaceURI();
        }
        if (StringHelper.isBlank(wsseNSURI)) {
            return null;
        }
        if (!localName.equals(expectedLocalName)) {
            return null;
        }
        if (!WSSecExt.isSupportedNamespace(wsseNSURI)) {
            return null;
        }
        if (wsseNSURI.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) {
            return new WSSecExt(WSSecExtVersion.V10);
        }
        if (!wsseNSURI.equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) {
            return new WSSecExt(WSSecExtVersion.V11);
        }
        return null;
    }
}

