/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.custom.alf.element.impl;

import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSObject;

public abstract class BaseWSTrustAlfClaimsObjectImpl
extends BaseWSObject
implements BaseWSInterface {
    static final Logger log = Logger.getLogger(BaseWSTrustAlfClaimsObjectImpl.class);

    public boolean baseIsCompatibleElement(OMElement element, String expectedLocalName) throws SSOException {
        String localName = element.getLocalName();
        String wsalfNSURI = element.getNamespace().getNamespaceURI();
        if (wsalfNSURI == null || wsalfNSURI.trim().length() == 0) {
            wsalfNSURI = element.getDefaultNamespace().getNamespaceURI();
        }
        if (wsalfNSURI == null || wsalfNSURI.trim().length() == 0) {
            log.error((Object)("Could not determine namespace for <" + localName + ">"));
            throw new SSOException("Unknown alf namespace");
        }
        if (!localName.equals(expectedLocalName)) {
            log.error((Object)("Unknown element <" + localName + "> when expecting <" + expectedLocalName + ">"));
            return false;
        }
        if (!wsalfNSURI.equals("http://www.eclipse.org/ALF/1.0/claims")) {
            log.error((Object)("Unknown wsp namespace \"" + wsalfNSURI + "\" in <" + expectedLocalName + "> found"));
            throw new SSOException("Unknown wsp namespace");
        }
        return true;
    }
}

