/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration;

import org.apache.axiom.om.OMElement;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class ConfigParameter
implements Cloneable {
    public static final int CONFIG_PARAM_TYPE_UNKNOWN = 0;
    public static final int CONFIG_PARAM_TYPE_TEXT = 1;
    public static final int CONFIG_PARAM_TYPE_OMELEMENT = 2;
    private int type = 0;
    private String name;
    private Object value;
    private OMElement element;

    public ConfigParameter() {
    }

    public ConfigParameter(ConfigParameter other) {
        this.type = other.type;
        this.name = other.name;
        this.value = other.value;
        this.element = other.element;
    }

    public ConfigParameter(String name, Object value) {
        this.name = name;
        this.value = value;
        this.type = value instanceof OMElement ? 2 : (value instanceof String ? 1 : 0);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OMElement getElement() {
        return this.element;
    }

    public void setElement(OMElement element) {
        this.element = element;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.type = value instanceof OMElement ? 2 : (value instanceof String ? 1 : 0);
    }

    public String toString() {
        return this.name + "=" + this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConfigParameter) {
            return ((ConfigParameter)obj).name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getStringValue() {
        return this.getStringValue(null);
    }

    public String getStringValue(String defaultValue) {
        if (this.type == 1) {
            String s = (String)this.value;
            if (StringHelper.isBlank(s)) {
                return defaultValue;
            }
            return s;
        }
        return defaultValue;
    }

    public Integer getIntValue(Integer defaultValue) {
        if (this.type == 1) {
            String s = (String)this.value;
            if (StringHelper.isBlank(s)) {
                return defaultValue;
            }
            try {
                return new Integer(s);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public Long getLongValue(Long defaultValue) {
        if (this.type == 1) {
            String s = (String)this.value;
            if (StringHelper.isBlank(s)) {
                return defaultValue;
            }
            try {
                return new Long(s);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public Boolean getBooleanValue(Boolean defaultValue) {
        if (this.type == 1) {
            String s = (String)this.value;
            if (StringHelper.isBlank(s)) {
                return defaultValue;
            }
            if (s.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (s.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            if (s.equalsIgnoreCase("yes")) {
                return Boolean.TRUE;
            }
            if (s.equalsIgnoreCase("no")) {
                return Boolean.FALSE;
            }
            if (s.equalsIgnoreCase("1")) {
                return Boolean.TRUE;
            }
            if (s.equalsIgnoreCase("0")) {
                return Boolean.FALSE;
            }
        }
        return defaultValue;
    }

    public OMElement getOMElementValue(OMElement defaultValue) {
        if (this.type == 2) {
            return (OMElement)this.value;
        }
        return defaultValue;
    }

    public Object clone() {
        return new ConfigParameter(this);
    }
}

