/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.matcher;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.AbstractMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.URIMatcherHttpParamSet;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class URIMatcher
extends AbstractMatcher {
    private static final Logger log = Logger.getLogger(URIMatcher.class);
    public static final String DEFAULT_REQUEST_URI = "*";
    public static final String DEFAULT_REQUEST_URI_JAVAREGEX = ".*";
    private String requestURI;
    private HashSet httpParamSetSet;
    private Pattern requestURIPattern;

    public URIMatcher() {
        this.reset();
    }

    public URIMatcher(int matcherType) {
        super(matcherType);
        this.reset();
    }

    public URIMatcher(int matcherType, String requestURI, HashSet httpParamSetSet) throws SSOException {
        super(matcherType);
        this.reset();
        this.requestURI = requestURI;
        this.httpParamSetSet = httpParamSetSet;
        if (matcherType == 2) {
            try {
                this.requestURIPattern = Pattern.compile(requestURI);
            }
            catch (PatternSyntaxException e) {
                String errorMessage = "Invalid regex pattern: \"" + requestURI + "\"";
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage, e);
            }
        }
    }

    public void reset() {
        this.httpParamSetSet = new HashSet();
        if (this.matcherType == 2) {
            this.requestURI = DEFAULT_REQUEST_URI_JAVAREGEX;
            try {
                this.requestURIPattern = Pattern.compile(this.requestURI);
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        } else if (this.matcherType == 1) {
            this.requestURI = DEFAULT_REQUEST_URI;
        } else {
            throw new RuntimeException("Invalid matcher type: \"" + this.matcherType + "\"");
        }
    }

    public boolean isMatchAllMatcher() {
        String defaultPattern = this.matcherType == 2 ? DEFAULT_REQUEST_URI : DEFAULT_REQUEST_URI_JAVAREGEX;
        return this.requestURI.equals(defaultPattern) && this.httpParamSetSet != null && this.httpParamSetSet.size() == 0;
    }

    public boolean matches(String uri, Map httpParamsMap) {
        if (this.matcherType == 2) {
            Matcher uriMatcher = this.requestURIPattern.matcher(uri);
            if (uriMatcher == null || !uriMatcher.matches()) {
                return false;
            }
        } else if (this.matcherType == 1) {
            int valueMatchScore = StringHelper.basicWildcardMatchWithMatchScore(this.requestURI, uri);
            boolean matches = valueMatchScore >= 0;
            this.matchScore = matches ? new Long(valueMatchScore) : new Long(-1L);
            if (!matches) {
                return false;
            }
        } else {
            throw new RuntimeException("Invalid matcher type: \"" + this.matcherType + "\"");
        }
        if (httpParamsMap == null) {
            return true;
        }
        HashMap matchedParamsCache = new HashMap();
        Iterator it = this.httpParamSetSet.iterator();
        if (it != null) {
            if (!it.hasNext()) {
                return true;
            }
            while (it.hasNext()) {
                URIMatcherHttpParamSet matchParamSet = (URIMatcherHttpParamSet)it.next();
                if (!matchParamSet.matches(httpParamsMap, matchedParamsCache)) continue;
                return true;
            }
        }
        return false;
    }

    public void addHttpParamSet(URIMatcherHttpParamSet httpParamSet) {
        this.httpParamSetSet.add(httpParamSet);
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) throws SSOException {
        if (StringHelper.isBlank(requestURI)) {
            this.requestURI = DEFAULT_REQUEST_URI;
        }
        this.requestURI = requestURI;
        if (this.matcherType == 2) {
            try {
                this.requestURIPattern = Pattern.compile(requestURI);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set parameter name regex: " + requestURI;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
        }
    }

    public static String getMatchExpressionAsString(String uri, Map httpParamsMap) {
        if (httpParamsMap.isEmpty()) {
            return uri;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(uri);
        sb.append('?');
        for (String name : httpParamsMap.keySet()) {
            String[] values = (String[])httpParamsMap.get(name);
            for (int i = 0; i < values.length; ++i) {
                sb.append('&');
                sb.append(name);
                sb.append('=');
                sb.append(values[i]);
            }
        }
        return sb.toString();
    }

    public static int calculateMatchExpressionsHash(String uri, Map httpParamsMap) {
        return URIMatcher.getMatchExpressionAsString(uri, httpParamsMap).hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.httpParamSetSet.isEmpty()) {
            sb.append(this.requestURI);
            return sb.toString();
        }
        for (URIMatcherHttpParamSet paramSet : this.httpParamSetSet) {
            sb.append("[");
            sb.append(this.requestURI);
            sb.append("?");
            sb.append(paramSet.toString());
            sb.append("],");
        }
        String retVal = sb.toString();
        retVal = retVal.substring(0, retVal.length() - 2);
        return retVal;
    }
}

