/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.impl;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.XMLUtils;
import org.apache.log4j.Logger;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyValue;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Attribute;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Handler;
import org.eclipse.alf.security.sso.common.token.saml.impl.SAML1AttributeImpl;
import org.eclipse.alf.security.sso.common.token.saml.impl.SAML1Helper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SignedSecurityToken;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAudienceRestrictionCondition;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLDoNotCacheCondition;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML1HandlerImpl
implements SAML1Handler {
    static final Logger log = Logger.getLogger(SAML1HandlerImpl.class);
    private static final String SAML_ASSERTION_ID = "urn:oasis:names:tc:SAML:1.0:assertion#Assertion";
    private SAMLAssertion assertion = null;

    public SAML1HandlerImpl(Element element) throws SSOException {
        String newLine = System.getProperty("line.separator");
        try {
            this.assertion = new SAMLAssertion(element);
        }
        catch (SAMLException e) {
            log.error((Object)("Error creating SAMLAssertion object from " + newLine + element.toString()));
            throw new SSOException("Error creating SAMLAssertion object", e);
        }
    }

    public SAML1HandlerImpl(OMElement element) throws SSOException {
        String newLine = System.getProperty("line.separator");
        try {
            Element domelement = XMLUtils.toDOM((OMElement)element);
            this.assertion = new SAMLAssertion(domelement);
        }
        catch (Throwable e) {
            log.error((Object)("Error creating SAMLAssertion object from" + newLine + element.toString()));
            throw new SSOException("Error creating SAMLAssertion object", e);
        }
    }

    public SAML1HandlerImpl(Object assertion) throws SSOException {
        if (!(assertion instanceof SAMLAssertion)) {
            log.error((Object)("Error creating token hander object from native object: " + assertion.getClass().getName()));
            throw new SSOException("Error creating token handler");
        }
        this.assertion = (SAMLAssertion)assertion;
    }

    public Object getNativeObject() {
        return this.assertion;
    }

    public void setNativeObject(Object object) {
        this.assertion = (SAMLAssertion)object;
    }

    public Node toDOM() throws SSOException {
        try {
            return this.assertion.toDOM();
        }
        catch (SAMLException e) {
            log.error((Object)"Error in toDOM()");
            throw new SSOException("Error converting toDOM()", e);
        }
    }

    public void fromDOM(Element element) throws SSOException {
        try {
            this.assertion.fromDOM(element);
        }
        catch (SAMLException e) {
            log.error((Object)"Error in fromDOM()");
            throw new SSOException("Error in fromDOM()", e);
        }
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return this.assertion.getMinorVersion();
    }

    public String getVersion() {
        return "1." + this.assertion.getMinorVersion();
    }

    public String getTokenType() {
        return "saml:SAML";
    }

    public String getTokenVersion() {
        if (this.assertion.getMinorVersion() == 0) {
            return "1.0";
        }
        if (this.assertion.getMinorVersion() == 1) {
            return "1.1";
        }
        return "1.0";
    }

    public QName getTokenQName() {
        return new QName("urn:oasis:names:tc:SAML:1.0:assertion", "saml");
    }

    public Date getNotBefore() {
        return this.assertion.getNotBefore();
    }

    public Date getNotOnOrAfter() {
        return this.assertion.getNotOnOrAfter();
    }

    public String getId() {
        return this.assertion.getId();
    }

    public Date getIssueInstant() {
        return this.assertion.getIssueInstant();
    }

    public String getIssuer() {
        return this.assertion.getIssuer();
    }

    public String getAuthMethod() {
        Iterator statements = this.assertion.getStatements();
        while (statements.hasNext()) {
            SAMLStatement statement = (SAMLStatement)statements.next();
            if (!(statement instanceof SAMLAuthenticationStatement)) continue;
            return ((SAMLAuthenticationStatement)statement).getAuthMethod();
        }
        return null;
    }

    public String[] getAudienceRestrictions() {
        ArrayList<String> retVal = new ArrayList<String>();
        Iterator conditionsIt = this.assertion.getConditions();
        if (conditionsIt != null) {
            while (conditionsIt.hasNext()) {
                SAMLAudienceRestrictionCondition audienceRestrictionCondition;
                Iterator audiencesIt;
                SAMLCondition condition = (SAMLCondition)conditionsIt.next();
                if (!(condition instanceof SAMLAudienceRestrictionCondition) || (audiencesIt = (audienceRestrictionCondition = (SAMLAudienceRestrictionCondition)condition).getAudiences()) == null) continue;
                while (audiencesIt.hasNext()) {
                    String audience = (String)audiencesIt.next();
                    retVal.add(audience);
                }
            }
        }
        String[] rv = new String[retVal.size()];
        retVal.toArray(rv);
        return rv;
    }

    public Date getAuthInstant() {
        Iterator statements = this.assertion.getStatements();
        while (statements.hasNext()) {
            SAMLStatement statement = (SAMLStatement)statements.next();
            if (!(statement instanceof SAMLAuthenticationStatement)) continue;
            return ((SAMLAuthenticationStatement)statement).getAuthInstant();
        }
        return null;
    }

    public String getNameIdentifier() {
        Iterator statements = this.assertion.getStatements();
        while (statements.hasNext()) {
            SAMLNameIdentifier nameIdentifier;
            SAMLSubjectStatement subjectStatement;
            SAMLSubject subject;
            SAMLStatement statement = (SAMLStatement)statements.next();
            if (!(statement instanceof SAMLSubjectStatement) || (subject = (subjectStatement = (SAMLSubjectStatement)statement).getSubject()) == null || (nameIdentifier = subject.getNameIdentifier()) == null) continue;
            return nameIdentifier.getName();
        }
        return null;
    }

    public String getNameIdentifierQualifier() {
        Iterator statements = this.assertion.getStatements();
        while (statements.hasNext()) {
            SAMLNameIdentifier nameIdentifier;
            SAMLSubjectStatement subjectStatement;
            SAMLSubject subject;
            SAMLStatement statement = (SAMLStatement)statements.next();
            if (!(statement instanceof SAMLSubjectStatement) || (subject = (subjectStatement = (SAMLSubjectStatement)statement).getSubject()) == null || (nameIdentifier = subject.getNameIdentifier()) == null) continue;
            return nameIdentifier.getNameQualifier();
        }
        return null;
    }

    public String getNameIdentifierFormat() {
        Iterator statements = this.assertion.getStatements();
        while (statements.hasNext()) {
            SAMLNameIdentifier nameIdentifier;
            SAMLSubjectStatement subjectStatement;
            SAMLSubject subject;
            SAMLStatement statement = (SAMLStatement)statements.next();
            if (!(statement instanceof SAMLSubjectStatement) || (subject = (subjectStatement = (SAMLSubjectStatement)statement).getSubject()) == null || (nameIdentifier = subject.getNameIdentifier()) == null) continue;
            return nameIdentifier.getFormat();
        }
        return null;
    }

    public String getSubjectIPAddress() {
        Iterator statements = this.assertion.getStatements();
        while (statements.hasNext()) {
            SAMLStatement statement = (SAMLStatement)statements.next();
            if (!(statement instanceof SAMLAuthenticationStatement)) continue;
            return ((SAMLAuthenticationStatement)statement).getSubjectIP();
        }
        return null;
    }

    public String getSubjectDNSAddress() {
        Iterator statements = this.assertion.getStatements();
        while (statements.hasNext()) {
            SAMLStatement statement = (SAMLStatement)statements.next();
            if (!(statement instanceof SAMLAuthenticationStatement)) continue;
            return ((SAMLAuthenticationStatement)statement).getSubjectDNS();
        }
        return null;
    }

    public Iterator getSubjectConfirmationMethods() {
        Iterator statements = this.assertion.getStatements();
        while (statements.hasNext()) {
            SAMLStatement statement = (SAMLStatement)statements.next();
            if (statement instanceof SAMLAuthenticationStatement) {
                return ((SAMLAuthenticationStatement)statement).getSubject().getConfirmationMethods();
            }
            if (!(statement instanceof SAMLAttributeStatement)) continue;
            return ((SAMLAttributeStatement)statement).getSubject().getConfirmationMethods();
        }
        return null;
    }

    public Element getSubjectKeyInfoElement() {
        Iterator statements = this.assertion.getStatements();
        while (statements.hasNext()) {
            SAMLStatement statement = (SAMLStatement)statements.next();
            if (!(statement instanceof SAMLSubjectStatement)) continue;
            return ((SAMLSubjectStatement)statement).getSubject().getKeyInfo();
        }
        return null;
    }

    public X509Certificate getSubjectX509Certificate() {
        Element keyInfoElement = this.getSubjectKeyInfoElement();
        if (keyInfoElement == null) {
            return null;
        }
        X509Certificate cert = null;
        try {
            KeyInfo keyInfo = new KeyInfo(keyInfoElement, null);
            if (keyInfo.containsX509Data()) {
                X509Data data = keyInfo.itemX509Data(0);
                XMLX509Certificate certElem = null;
                if (data != null && data.containsCertificate()) {
                    certElem = data.itemCertificate(0);
                }
                if (certElem != null) {
                    cert = certElem.getX509Certificate();
                }
            }
        }
        catch (XMLSecurityException e) {
            log.error((Object)"Failed to cannot get certificate (key holder)", (Throwable)e);
            return null;
        }
        return cert;
    }

    public PublicKey getSubjectPublicKey() {
        Element keyInfoElement = this.getSubjectKeyInfoElement();
        if (keyInfoElement == null) {
            return null;
        }
        PublicKey publicKey = null;
        try {
            KeyValue keyValue;
            KeyInfo keyInfo = new KeyInfo(keyInfoElement, null);
            if (keyInfo.containsKeyValue() && (keyValue = keyInfo.itemKeyValue(0)) != null) {
                publicKey = keyValue.getPublicKey();
            }
        }
        catch (XMLSecurityException e) {
            log.error((Object)"Failed to cannot get public key (key holder)", (Throwable)e);
            return null;
        }
        return publicKey;
    }

    public Iterator getAllowedAudiences() {
        ArrayList<String> allowedAudiences = new ArrayList<String>();
        Iterator conditions = this.assertion.getConditions();
        while (conditions.hasNext()) {
            SAMLCondition condition = (SAMLCondition)conditions.next();
            if (!(condition instanceof SAMLAudienceRestrictionCondition)) continue;
            Iterator audiences = ((SAMLAudienceRestrictionCondition)condition).getAudiences();
            while (audiences.hasNext()) {
                String audience = (String)audiences.next();
                allowedAudiences.add(audience);
            }
        }
        return allowedAudiences.iterator();
    }

    public boolean getCacheable() {
        Iterator conditions = this.assertion.getConditions();
        while (conditions.hasNext()) {
            SAMLCondition condition = (SAMLCondition)conditions.next();
            if (!(condition instanceof SAMLDoNotCacheCondition)) continue;
            return true;
        }
        return false;
    }

    public SAML1Attribute getAttribute(String attrName, String attrNS) {
        Iterator statements = this.assertion.getStatements();
        if (statements != null) {
            while (statements.hasNext()) {
                SAMLStatement statement = (SAMLStatement)statements.next();
                if (!(statement instanceof SAMLAttributeStatement)) continue;
                SAMLAttributeStatement attribiteStatement = (SAMLAttributeStatement)statement;
                Iterator attributes = attribiteStatement.getAttributes();
                while (attributes.hasNext()) {
                    SAMLAttribute attribute = (SAMLAttribute)attributes.next();
                    if (!attrName.equals(attribute.getName()) || !attrNS.equals(attribute.getNamespace())) continue;
                    return new SAML1AttributeImpl(attribute);
                }
            }
        }
        return null;
    }

    public Iterator getAttributeValues(String attrName, String attrNS) {
        SAML1Attribute attribute = this.getAttribute(attrName, attrNS);
        if (attribute == null) {
            return null;
        }
        return attribute.getValues();
    }

    public QName getAttributeType(String attrName, String attrNS) {
        SAML1Attribute attribute = this.getAttribute(attrName, attrNS);
        if (attribute == null) {
            return null;
        }
        return attribute.getType();
    }

    public long getAttributeLifetime(String attrName, String attrNS) {
        SAML1Attribute attribute = this.getAttribute(attrName, attrNS);
        if (attribute == null) {
            return 0L;
        }
        return attribute.getLifetime();
    }

    public boolean hasAttribute(String attrName, String attrNS) {
        SAML1Attribute attribute = this.getAttribute(attrName, attrNS);
        return attribute != null;
    }

    public Iterator getAttributes() {
        ArrayList<SAML1AttributeImpl> retVal = new ArrayList<SAML1AttributeImpl>();
        Iterator statements = this.assertion.getStatements();
        if (statements != null) {
            while (statements.hasNext()) {
                SAMLStatement statement = (SAMLStatement)statements.next();
                if (!(statement instanceof SAMLAttributeStatement)) continue;
                SAMLAttributeStatement attribiteStatement = (SAMLAttributeStatement)statement;
                Iterator attributes = attribiteStatement.getAttributes();
                while (attributes.hasNext()) {
                    SAMLAttribute attribute = (SAMLAttribute)attributes.next();
                    retVal.add(new SAML1AttributeImpl(attribute));
                }
            }
        }
        return retVal.iterator();
    }

    public Iterator getSignatureCertificates() {
        try {
            return this.assertion.getX509Certificates();
        }
        catch (SAMLException e) {
            return null;
        }
    }

    public PublicKey getSignaturePublicKey() {
        return SAML1Helper.getPublicKeyFromSignature(this.assertion);
    }

    public boolean compareTo(Object other) {
        return SAML1Helper.compareSignatures(this.assertion, (SAMLAssertion)other);
    }

    public static boolean isCompatibleTokenType(String tokenTypeURI) {
        return tokenTypeURI.equals(SAML_ASSERTION_ID);
    }

    public String toString() {
        return this.assertion.toString();
    }

    public OMElement toOM() throws SSOException {
        try {
            Element domElement = (Element)this.assertion.toDOM();
            OMElement omElement = XMLHelper.toOM(domElement);
            return omElement;
        }
        catch (SAMLException e) {
            log.error((Object)"Failed to create DOM representation of SAML assertion", (Throwable)e);
            throw new SSOException("Failed to create DOM representation of SAML assertion", e);
        }
    }

    public SignedSecurityToken toSecurityToken() {
        return WSAbstractFactory.getWSSEObjectFactory().createSAML1Token(this.assertion);
    }

    public boolean isSAMLElementShallow(OMElement element) {
        if (element == null) {
            return false;
        }
        return element.getLocalName().equals("Assertion") && element.getNamespace().getNamespaceURI().equals("urn:oasis:names:tc:SAML:1.0:assertion");
    }

    static {
        SAMLConfig.instance();
    }
}

