/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.validator;

import java.util.Date;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.token.SSOTokenValidationResult;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Handler;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.ExpirationPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.BasePolicyValidator;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.opensaml.SAMLAssertion;

public class ExpirationPolicyValidator
extends BasePolicyValidator {
    private static final Logger log = Logger.getLogger(ExpirationPolicyValidator.class);

    protected boolean isExpired(Date notBefore, Date notOnOrAfter, long leeway) {
        long now = System.currentTimeMillis();
        long d1 = notBefore.getTime();
        long d2 = notOnOrAfter.getTime();
        return now < d1 - leeway || now >= d2 + leeway;
    }

    public ExtendedResult validate(SAML1Handler samlHandler, BasePolicy policy) {
        long expirationLeeway;
        SSOTokenValidationResult result = new SSOTokenValidationResult();
        ExpirationPolicy expirationPolicy = (ExpirationPolicy)policy;
        SAMLAssertion assertion = (SAMLAssertion)samlHandler.getNativeObject();
        long l = expirationLeeway = expirationPolicy != null ? expirationPolicy.getExpirationLeeway() : 0L;
        if (this.isExpired(assertion.getNotBefore(), assertion.getNotOnOrAfter(), expirationLeeway)) {
            log.debug((Object)("SAML validation: expired assertion: NotBefore=\"" + SSOHelper.formatInZuluTime(assertion.getNotBefore()) + "\", NotOnOrAfter=\"" + SSOHelper.formatInZuluTime(assertion.getNotOnOrAfter()) + "\""));
            result.setCode(10);
            return result;
        }
        result.setCode(0);
        return result;
    }
}

