/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLHelper {
    private static final Logger log = Logger.getLogger(XMLHelper.class);

    public static String toString(OMElement element) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        element.serialize((OutputStream)os);
        return os.toString("UTF-8");
    }

    public static OMElement toOM(String xmlString) throws SSOException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes());
            XMLInputFactory xmlInputFactory = null;
            try {
                xmlInputFactory = XMLInputFactory.newInstance();
            }
            catch (FactoryConfigurationError e) {
                log.error((Object)("StAX XMLInputFactory cannot be instantiated: " + e.getMessage()));
                throw e;
            }
            StAXOMBuilder builder = new StAXOMBuilder(xmlInputFactory.createXMLStreamReader(is));
            return builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error while parsing XML string [" + xmlString + "]"), (Throwable)e);
            throw new SSOException("Error parsing XML string", e);
        }
        catch (Exception e) {
            log.error((Object)("Error while parsing XML string [" + xmlString + "]"), (Throwable)e);
            throw new SSOException("Error parsing XML string", e);
        }
    }

    public static Element toDOM(OMElement omElement) throws SSOException {
        if (null == omElement) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            omElement.serialize((OutputStream)outputStream);
        }
        catch (Exception e) {
            log.error((Object)"Error converting an OMElement to an equivalent DOM Element", (Throwable)e);
            return null;
        }
        if (0 == outputStream.size()) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document domDocument = documentBuilder.parse(inputStream);
            return domDocument.getDocumentElement();
        }
        catch (Exception e) {
            log.error((Object)("Error converting to DOM" + e.getLocalizedMessage()));
            throw new SSOException("Error converting to DOM");
        }
    }

    public static OMElement toOM(Element domElement) throws SSOException {
        if (null == domElement) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XMLSerializer xmlSerializer = new XMLSerializer((OutputStream)outputStream, null);
        xmlSerializer.setNamespaces(true);
        try {
            xmlSerializer.serialize(domElement);
        }
        catch (IOException e) {
            log.error((Object)"Error serializing DOM element", (Throwable)e);
            throw new SSOException("Error serializing DOM element", e);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader reader = null;
        try {
            reader = xif.createXMLStreamReader(inputStream);
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error creating XML stream reader", (Throwable)e);
            throw new SSOException("Error creating XML stream reader", e);
        }
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        return builder.getDocumentElement();
    }

    public static OMElement createOMElement(OMElement parent, String ns, String ln, String prefix) {
        return parent.getOMFactory().createOMElement(new QName(ns, ln, prefix), (OMContainer)parent);
    }

    public static OMElement createOMElement(OMElement parent, OMNamespace ns, String ln) {
        return parent.getOMFactory().createOMElement(ln, ns);
    }

    public static String escapeXMLString1(String xmlString) {
        String result = new String(xmlString);
        result = result.replaceAll("&", "&amp;");
        result = result.replaceAll("'", "&apos;");
        result = result.replaceAll("<", "&lt;");
        result = result.replaceAll(">", "&gt;");
        result = result.replaceAll("\"", "&quot;");
        return result;
    }

    public static String getAttribute(OMElement el, String attributeName) {
        if (el == null) {
            log.error((Object)"Invalid argument: null");
            return null;
        }
        if (StringHelper.isBlank(attributeName)) {
            log.error((Object)"Invlaid argument: attribute name is empty");
            return null;
        }
        OMAttribute attr = el.getAttribute(new QName(attributeName));
        if (attr != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("@" + attributeName + " attribute parsed: " + attr.getAttributeValue()));
            }
            return attr.getAttributeValue().trim();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("@" + attributeName + " attribute is missing"));
        }
        return null;
    }
}

