/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.addressing.element.impl;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.addressing.WSAddressing;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.Address;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.impl.BaseWSAddressingObjectImpl;

public class AddressImpl
extends BaseWSAddressingObjectImpl
implements Address {
    private static final Logger log = Logger.getLogger(AddressImpl.class);
    protected String address;

    public AddressImpl() {
        this.reset();
    }

    public AddressImpl(String address) {
        this.reset();
        this.address = address;
    }

    public String getLocalName() {
        return "Address";
    }

    public void reset() {
        super.reset();
        this.address = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof AddressImpl) {
            AddressImpl otherAddressImpl = (AddressImpl)other;
            this.address = otherAddressImpl.address;
        }
    }

    public void setAddress(String address) {
        this.address = address;
        this.setDirty();
    }

    public String getAddress() {
        return this.address;
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement addressEl = WSAddressing.createOMElement(parent, this.getLocalName());
        if (this.address != null) {
            addressEl.setText(this.address);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + addressEl.toString() + "]"));
        }
        this.addAnyAttributesToElement(addressEl);
        this.addAnyElementsToElementAsChildren(addressEl);
        return addressEl;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        if (!this.isCompatibleElement(element)) {
            return null;
        }
        AddressImpl address = new AddressImpl();
        address.address = element.getText();
        address.setParseSource(element);
        this.copyFrom(address);
        return this;
    }
}

