/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.TokenType;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.BaseWSTrustObjectImpl;

public class TokenTypeImpl
extends BaseWSTrustObjectImpl
implements TokenType {
    private static final Logger log = Logger.getLogger(TokenTypeImpl.class);
    protected WSTrust wst;
    protected String tokenType;

    public TokenTypeImpl() {
        this.reset();
        this.wst = new WSTrust();
    }

    public TokenTypeImpl(WSTrust wst) {
        this.reset();
        this.wst = wst;
    }

    public TokenTypeImpl(WSTrust wst, String tokenType) {
        this.reset();
        this.wst = wst;
        this.tokenType = tokenType;
    }

    public String getLocalName() {
        return "TokenType";
    }

    public void reset() {
        super.reset();
        this.tokenType = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof TokenTypeImpl) {
            TokenTypeImpl otherTokenTypeImpl = (TokenTypeImpl)other;
            this.wst = otherTokenTypeImpl.wst;
            this.tokenType = otherTokenTypeImpl.tokenType;
        }
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
        this.setDirty();
    }

    public boolean isKnownTokenType(String tokenType) {
        if (tokenType.equals("urn:oasis:names:tc:SAML:1.0:assertion#Assertion")) {
            return true;
        }
        if (tokenType.equals("urn:oasis:names:tc:SAML:2.0:assertion#Assertion")) {
            return true;
        }
        if (tokenType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken")) {
            return true;
        }
        return tokenType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement tokenTypeEl = this.wst.createOMElement(parent, this.getLocalName());
        tokenTypeEl.setText(this.tokenType);
        this.addAnyAttributesToElement(tokenTypeEl);
        this.addAnyElementsToElementAsChildren(tokenTypeEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + tokenTypeEl.toString() + "]"));
        }
        return tokenTypeEl;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementTrust(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        WSTrust wst = this.baseIsCompatibleElementTrust(element, this.getLocalName());
        if (wst == null) {
            return null;
        }
        TokenTypeImpl tokenType = new TokenTypeImpl(wst);
        tokenType.tokenType = element.getText();
        tokenType.setParseSource(element);
        this.copyFrom(tokenType);
        return this;
    }

    public WSTrust getWSTrust() {
        return this.wst;
    }
}

