//
// ======  cookies.js  ======
//
//  Functions for setting and reading Cookies
//
//  Source: Annon - Brian Carroll has used this file since 1999 when
//  teaching Web Site Development

var cookiesJS_found = 1;
// 
//  ---------- setOneHourCookie  ----------
    function setOneDayCookie(cookieName, cookieValue) {
        var expdate = new Date();

        alert ("setOneDayCookie: Before setting cookie in the browser.\n" +
               "                  name  = " + cookieName + "\n" + 
               "                  value = " + cookieValue);

        // Set Cookie to expiration in one day
        expdate.setTime (expdate.getTime() + (24 * 60 * 60 * 1000));
        setCookie (cookieName,
                cookieValue,
                expdate,
                "/");
        return false;
    }
    
//  ---------- setOneHourCookie  ----------
    function setOneHourCookie(cookieName, cookieValue) {
        var expdate = new Date();

        alert ("setOneHourCookie: Before setting cookie in the browser.\n" +
               "                  name  = " + cookieName + "\n" + 
               "                  value = " + cookieValue);
        
        // Set Cookie to expiration in one hour
        expdate.setTime (expdate.getTime() + (1 * 60 * 60 * 1000));
        setCookie (cookieName,
                cookieValue,
                expdate,
                "/");
        return false;
    }
    
    
//  ---------- setFiveMinuteCookie  ----------
    function setFiveMinuteCookie(cookieName, cookieValue) {
        var expdate = new Date();

        alert ("setFiveMinuteCookie: Before setting cookie in the browser.\n" +
               "                  name  = " + cookieName + "\n" + 
               "                  value = " + cookieValue);
        
        // Set Cookie to expiration in one hour
        expdate.setTime (expdate.getTime() + (1 * 5 * 60 * 1000));
        setCookie (cookieName,
                cookieValue,
                expdate,
                "/");
        return false;
    }
    
//  ---------- setTwoMinuteCookie  ----------
    function setTwoMinuteCookie(cookieName, cookieValue) {
        var expdate = new Date();

        alert ("setTwoMinuteCookie: Before setting cookie in the browser.\n" +
               "                  name  = " + cookieName + "\n" + 
               "                  value = " + cookieValue);
        
        // Set Cookie to expiration in one hour
        expdate.setTime (expdate.getTime() + (1 * 2 * 60 * 1000));
        setCookie (cookieName,
                cookieValue,
                expdate,
                "/");
        return (false);
    }    
//  ---------- getCookie  -----------
//  Function: return the value of a cookie, given its name
//  A null return string indicates there was no cookie by that name
    function getCookie(cookieName) {
        var cookie = " " + document.cookie;  // Obtain list of all cookies
        var search = " " + cookieName + "="; // Format the cookie search string
        var setStr = null;
        var offset = 0;    //Index to beginning of cookie
        var end = 0;       //Index to end of cookie
        if (cookie.length > 0) {
            offset = cookie.indexOf(search);
            if (offset != -1) {
                offset += search.length;
                // Cookies in the list are separated by a semicolon
                end = cookie.indexOf(";", offset)
                if (end == -1) {
                    end = cookie.length;
                }
                // Extract and then decode the value of the cookie
                setStr = unescape(cookie.substring(offset, end));
                
                alert ("getCookie: After finding cookie in the browser.\n" +
                "                  name  = " + cookieName + "\n" + 
                "                  value = " + setStr);
            } else {
            alert ("getCookie: No cookie named " + cookieName+ " found by the browser.\n");
            }
        } else {
           alert ("getCookie: No cookies at all found by browser.\n");
        }
        return(setStr);
    }
//
//  ----------  setCookie  ----------
// Concept: To add a cookie, set document.cookie to "name=value" and
//          it gets added to the list of cookies
//          The format is: name=value; expires=date; path=path;
//              domain=domain; secure
    function setCookie (name, value, expires, path, domain, secure) {
        document.cookie = name + "=" + escape(value) +
            ((expires) ? "; expires=" + expires.toGMTString() : "") +
            ((path) ? "; path=" + path : "") +
            ((domain) ? "; domain=" + domain : "") +
            ((secure) ? "; secure" : "");
    }

 