/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExpirableMap {
    static final Logger log = Logger.getLogger(ExpirableMap.class);
    protected Map map = new HashMap();
    protected long lastReapedInMillis = 0L;
    protected long reapIntervalInMillis = 1000L;
    protected long limitSize = Long.MAX_VALUE;

    public static synchronized ExpirableMap getSingletonInstance() {
        return ExpirableMapInstanceHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object data, long timeToLiveInSecods) {
        this.reap();
        if (data == null) {
            throw new IllegalArgumentException("Object to be stored cannot be null");
        }
        if ((long)this.map.size() >= this.limitSize) {
            return;
        }
        Date expires = null;
        if (timeToLiveInSecods >= 0L) {
            expires = new Date(System.currentTimeMillis() + timeToLiveInSecods * 1000L);
        }
        StorageEntry entry = new StorageEntry(data, expires);
        Map map = this.map;
        synchronized (map) {
            this.map.put(key, entry);
        }
    }

    public boolean hasData(Object key) {
        this.reap();
        if (key == null) {
            log.error((Object)"Invalid  argument");
            throw new NullPointerException();
        }
        return this.map.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.reap();
        Map map = this.map;
        synchronized (map) {
            this.clear();
        }
    }

    public boolean containsKey(Object key) {
        this.reap();
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        this.reap();
        Iterator it = this.map.values().iterator();
        if (it != null) {
            while (it.hasNext()) {
                StorageEntry entry = (StorageEntry)it.next();
                if (entry.getData() != null && value != null && entry.equals(value)) {
                    return true;
                }
                if (entry.getData() != null || value != null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        this.reap();
        return this.map.isEmpty();
    }

    public int size() {
        this.reap();
        return this.map.size();
    }

    public Object getAndRemove(Object key) {
        this.reap();
        if (key == null) {
            log.error((Object)"Invalid  argument");
            throw new NullPointerException();
        }
        StorageEntry entry = (StorageEntry)this.map.get(key);
        if (entry != null) {
            this.map.remove(key);
            return entry.getData();
        }
        return null;
    }

    public Object get(Object key) {
        this.reap();
        if (key == null) {
            log.error((Object)"Invalid  argument");
            throw new NullPointerException();
        }
        StorageEntry entry = (StorageEntry)this.map.get(key);
        if (entry != null) {
            return entry.getData();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        this.reap();
        if (key == null) {
            log.error((Object)"Invalid argument: key cannot be null");
            throw new IllegalArgumentException("key cannot be null");
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReapInterval(long reapIntervalInMillis) {
        Map map = this.map;
        synchronized (map) {
            this.reapIntervalInMillis = reapIntervalInMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimitSize(long limitSize) {
        Map map = this.map;
        synchronized (map) {
            this.limitSize = limitSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reap() {
        if (this.lastReapedInMillis + this.reapIntervalInMillis >= System.currentTimeMillis()) {
            return;
        }
        Map map = this.map;
        synchronized (map) {
            Iterator entriesIt = this.map.entrySet().iterator();
            if (entriesIt != null) {
                while (entriesIt.hasNext()) {
                    Date now;
                    Map.Entry entry = entriesIt.next();
                    StorageEntry data = (StorageEntry)entry.getValue();
                    if (data.getExpires() == null || (now = new Date(System.currentTimeMillis())).compareTo(data.getExpires()) <= 0) continue;
                    entriesIt.remove();
                }
            }
            this.lastReapedInMillis = System.currentTimeMillis();
        }
    }

    protected class StorageEntry {
        private Object data = null;
        private Date expires = null;

        private StorageEntry() {
        }

        public StorageEntry(Object data, Date expires) {
            this.data = data;
            this.expires = expires;
        }

        public Object getData() {
            return this.data;
        }

        public Date getExpires() {
            return this.expires;
        }
    }

    protected static class ExpirableMapInstanceHolder {
        private static ExpirableMap instance = new ExpirableMap();

        protected ExpirableMapInstanceHolder() {
        }
    }
}

