/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.cookie;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;

public class CookieData {
    private static final Logger log = Logger.getLogger(CookieData.class);
    protected static final int COOKIE_DATA_VERSION = 0;
    public static final String COOKIE_CONTENT_NS = "http://www.org.eclipse.alf/security/sso/wsfprp/cookie-schema-1.0.xsd";
    public static final String COOKIE_CONTENT_LN = "ALFSSOCookie";
    public static final String COOKIE_CONTENT_PREFIX = "alfsso";
    public static final String COOKIE_RELYING_PARTY_LN = "RelyingParty";
    public static final String COOKIE_SSOTOKEN_LN = "SSOToken";
    public static final String COOKIE_REMOTEUSERIP_LN = "RemoteUserIP";
    protected RPURI rpURI = null;
    protected SSOToken token = null;
    protected int cookieDataVersion = 0;
    protected String remoteUserIP = null;

    protected CookieData() {
    }

    public CookieData(String type, String realm, String instance, SSOToken token, String remoteUserIP) throws SSOException {
        String newLine = System.getProperty("line.separator");
        log.debug((Object)("Cookie. type=" + type + " realm=" + realm + " instance=" + instance + newLine + "    SSOToken=" + token + newLine + "    remoteUserIP=" + remoteUserIP));
        RPURI rpuri = RPURI.createRPURI(type, realm, instance);
        if (rpuri == null) {
            throw new SSOException("Failed to create relying party URI from \"" + type + ":" + realm + ":" + instance + "\"");
        }
        if (token == null) {
            throw new IllegalArgumentException("SSOToken cannot be null");
        }
        this.rpURI = rpuri;
        this.token = token;
        this.remoteUserIP = remoteUserIP;
    }

    public CookieData(String rpuriString, SSOToken token, String remoteUserIP) throws SSOException {
        RPURI rpuri = RPURI.createRPURI(rpuriString);
        if (rpuri == null) {
            throw new SSOException("Failed to create relying party URI from \"" + rpuriString + "\"");
        }
        if (token == null) {
            throw new IllegalArgumentException("SSOToken cannot be null");
        }
        this.rpURI = rpuri;
        this.token = token;
        this.remoteUserIP = remoteUserIP;
    }

    public CookieData(RPURI rpURI, SSOToken token, String remoteUserIP) throws SSOException {
        if (rpURI == null) {
            throw new IllegalArgumentException("RPURI cannot be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("SSOToken cannot be null");
        }
        this.rpURI = rpURI;
        this.token = token;
        this.remoteUserIP = remoteUserIP;
    }

    public String toXMLString() {
        OMFactory omFac = OMAbstractFactory.getOMFactory();
        OMElement retEl = omFac.createOMElement(COOKIE_CONTENT_LN, COOKIE_CONTENT_NS, COOKIE_CONTENT_PREFIX);
        OMElement rpEl = omFac.createOMElement(new QName(COOKIE_CONTENT_NS, COOKIE_RELYING_PARTY_LN), (OMContainer)retEl);
        String rpURIString = this.getRPURI() == null ? "" : this.getRPURI().toString();
        rpEl.setText(rpURIString);
        if (StringHelper.isNotBlank(this.remoteUserIP)) {
            rpEl = omFac.createOMElement(new QName(COOKIE_CONTENT_NS, COOKIE_REMOTEUSERIP_LN), (OMContainer)retEl);
            rpEl.setText(this.remoteUserIP);
        }
        OMElement tokenEl = omFac.createOMElement(new QName(COOKIE_CONTENT_NS, COOKIE_SSOTOKEN_LN), (OMContainer)retEl);
        if (this.token == null) {
            log.debug((Object)"Invalid data: null token");
        } else {
            try {
                tokenEl.addChild((OMNode)this.token.toOM());
            }
            catch (SSOException e) {
                log.error((Object)"Error serializing token", (Throwable)e);
                return null;
            }
        }
        return retEl.toString();
    }

    public CookieData fromString(String cookieContent) {
        OMElement cookieElement = null;
        try {
            cookieElement = XMLHelper.toOM(cookieContent);
        }
        catch (SSOException e) {
            log.debug((Object)"Invalid SSO cookie - non-xml content");
            return null;
        }
        if (cookieElement == null) {
            log.debug((Object)"Invalid SSO cookie - empty content");
            return null;
        }
        if (!cookieElement.getLocalName().equals(COOKIE_CONTENT_LN)) {
            log.debug((Object)("Invalid SSO cookie - bad format - main element not found: " + cookieElement.toString()));
            return null;
        }
        OMNamespace cookieContentNS = cookieElement.getNamespace();
        if (!cookieContentNS.getNamespaceURI().equals(COOKIE_CONTENT_NS)) {
            log.debug((Object)("Invalid SSO cookie - bad namespace:" + cookieContentNS.getNamespaceURI()));
            return null;
        }
        OMElement rpuriElement = cookieElement.getFirstChildWithName(new QName(COOKIE_CONTENT_NS, COOKIE_RELYING_PARTY_LN));
        if (rpuriElement == null) {
            log.debug((Object)"Failed to find <RelyingParty> element");
            return null;
        }
        String rp = rpuriElement.getText().trim();
        this.rpURI = RPURI.fromString(rp);
        if (this.rpURI == null) {
            log.error((Object)("Failed to parse RP-URI data: " + rp));
            return null;
        }
        OMElement remoteUserIPElement = cookieElement.getFirstChildWithName(new QName(COOKIE_CONTENT_NS, COOKIE_REMOTEUSERIP_LN));
        this.remoteUserIP = null;
        if (remoteUserIPElement == null) {
            log.debug((Object)"Failed to find <RemoteUserIP> element");
        } else {
            this.remoteUserIP = remoteUserIPElement.getText().trim();
        }
        OMElement tokenElement = cookieElement.getFirstChildWithName(new QName(COOKIE_CONTENT_NS, COOKIE_SSOTOKEN_LN));
        if (tokenElement == null) {
            log.debug((Object)"Failed to find <SSOToken> element");
            return null;
        }
        if ((tokenElement = tokenElement.getFirstElement()) == null) {
            log.debug((Object)"Missing token from data");
            return null;
        }
        this.token = null;
        try {
            this.token = SSOTokenFactory.createSSOToken(tokenElement);
        }
        catch (Throwable e) {
            log.debug((Object)("Invalid token object: " + tokenElement.toString()));
            return null;
        }
        return this;
    }

    public RPURI getRPURI() {
        return this.rpURI;
    }

    public void setRPURI(RPURI rpURI) {
        this.rpURI = rpURI;
    }

    public SSOToken getToken() {
        return this.token;
    }

    public void setToken(SSOToken token) {
        this.token = token;
    }

    public String toString() {
        return this.toXMLString();
    }

    public int getCookieDataVersion() {
        return this.cookieDataVersion;
    }

    public void setCookieDataVersion(int cookieDataVersion) {
        this.cookieDataVersion = cookieDataVersion;
    }

    public String getRemoteUserIP() {
        return this.remoteUserIP;
    }

    public void setRemoteUserIP(String remoteUserIP) {
        this.remoteUserIP = remoteUserIP;
    }
}

