/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.keystore;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.FileIOHelper;

public class KeystoreProvider
implements Cloneable {
    private static final Logger log = Logger.getLogger(KeystoreProvider.class);
    protected static final boolean AUTOLOAD_DEFAULT = true;
    protected String id;
    protected KeyStore keystore;
    protected String keystoreType;
    protected String keystoreFile;
    protected String keystorePassword;

    public KeystoreProvider() {
        this.reset();
    }

    public KeystoreProvider(KeystoreProvider other) {
        this.reset();
        this.id = other.id;
        this.keystore = other.keystore;
        this.keystoreType = other.keystoreType;
        this.keystoreFile = other.keystoreFile;
        this.keystorePassword = other.keystorePassword;
    }

    public KeystoreProvider(KeyStore keystore) {
        this.reset();
        this.keystore = keystore;
    }

    public KeystoreProvider(String keystoreType, String keystoreFile, String keystorePassword) {
        this.id = "default";
        this.keystore = null;
        this.keystoreType = keystoreType;
        this.keystoreFile = keystoreFile;
        this.keystorePassword = keystorePassword;
    }

    public void reset() {
        this.keystore = null;
        this.keystoreType = null;
        this.keystoreFile = null;
        this.keystorePassword = null;
    }

    public void loadKeystore() throws SSOException {
        this.loadKeystore(this.keystoreType, this.keystoreFile, this.keystorePassword);
    }

    public void loadKeystore(String keystoreType, String keystoreFile, String keystorePassword) throws SSOException {
        this.keystoreType = keystoreType;
        this.keystoreFile = keystoreFile;
        this.keystorePassword = keystorePassword;
        this.keystore = null;
        try {
            this.keystore = KeyStore.getInstance(keystoreType);
        }
        catch (KeyStoreException e) {
            log.error((Object)"Error creating keystore instance", (Throwable)e);
            throw new SSOException("Error creating keystore instance");
        }
        InputStream is = FileIOHelper.loadResource(null, keystoreFile);
        if (is == null) {
            log.error((Object)("Error opening keystore file from \"" + keystoreFile + "\""));
            throw new SSOException("Error opening keystore file from \"" + keystoreFile + "\"");
        }
        try {
            this.keystore.load(is, keystorePassword.toCharArray());
        }
        catch (Exception e) {
            log.error((Object)("Error loading keystore data from \"" + keystoreFile + "\":"), (Throwable)e);
            throw new SSOException("Error loading keystore data from \"" + keystoreFile + "\":");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Keystore file from \"" + keystoreFile + "\" failed to close properly"));
            }
        }
        if (this.keystore == null) {
            log.error((Object)("Keystore file from \"" + keystoreFile + "\" failed to load properly"));
            throw new SSOException("Keystore file from \"" + keystoreFile + "\" failed to load properly");
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public KeyStore getKeystore() {
        return this.keystore;
    }

    public void setKeystore(KeyStore keystore) {
        this.keystore = keystore;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public Object clone() {
        return new KeystoreProvider(this);
    }
}

