/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.token.SSOClaim;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class SSOClaimImpl
implements SSOClaim,
Cloneable {
    private static final Logger log = Logger.getLogger(SSOClaimImpl.class);
    String name = null;
    String namespace = null;
    List values = null;
    long lifetime = 0L;

    public SSOClaimImpl() {
        this.reset();
    }

    public SSOClaimImpl(SSOClaimImpl other) {
        this.reset();
        this.name = other.name;
        this.namespace = other.namespace;
        this.values = other.values;
        this.lifetime = other.lifetime;
    }

    public SSOClaimImpl(QName claimName) {
        this.reset();
        if (claimName != null) {
            this.name = claimName.getLocalPart();
            this.namespace = claimName.getNamespaceURI();
        }
    }

    public SSOClaimImpl(QName claimName, Iterator claimValues) {
        this.reset();
        if (claimName != null) {
            this.name = claimName.getLocalPart();
            this.namespace = claimName.getNamespaceURI();
        }
        if (claimValues != null) {
            while (claimValues.hasNext()) {
                Object claimValueObj = claimValues.next();
                if (!(claimValueObj instanceof String)) continue;
                this.values.add(claimValueObj);
            }
        }
    }

    public SSOClaimImpl(QName claimName, String claimValue) {
        this.reset();
        if (claimName != null) {
            this.name = claimName.getLocalPart();
            this.namespace = claimName.getNamespaceURI();
        }
        if (claimValue != null) {
            this.values.add(claimValue);
        }
    }

    public void reset() {
        this.name = null;
        this.namespace = null;
        this.values = new ArrayList();
        this.lifetime = 0L;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespaceURI) {
        this.namespace = namespaceURI;
    }

    public String getValue() {
        return (String)this.values.get(0);
    }

    public void setValue(String value) {
        this.values = new ArrayList();
        if (value != null) {
            this.values.add(value);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"SSOClaimImpl.setValue(null) called");
        }
    }

    public Iterator getValues() {
        return this.values.iterator();
    }

    public void setValues(Iterator values) {
        this.values = new ArrayList();
        if (values != null) {
            while (values.hasNext()) {
                Object claimValueObj = values.next();
                if (claimValueObj instanceof String) {
                    this.values.add(claimValueObj);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"SSOClaimImpl.setValues(): non-string claim value encountered");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"SSOClaimImpl.setValues(null) called");
        }
    }

    public void addValue(String value) {
        if (value != null) {
            this.values.add(value);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"SSOClaimImpl.addValue(null) called");
        }
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public boolean equalName(SSOClaim anObject) {
        if (anObject instanceof SSOClaim) {
            SSOClaim other = anObject;
            if (StringHelper.isNotBlank(this.getName()) && StringHelper.isNotBlank(this.getNamespace()) && StringHelper.isNotBlank(other.getName()) && StringHelper.isNotBlank(other.getNamespace()) && this.getName().equals(other.getName()) && this.getNamespace().equals(other.getNamespace())) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        return new SSOClaimImpl(this);
    }
}

