/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy;

import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.token.SSOClaim;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;

public class ClaimPolicy
extends BasePolicy
implements Cloneable {
    private static final Logger log = Logger.getLogger(ClaimPolicy.class);
    private static final boolean DEFAULT_ENFORCED = true;
    public static final boolean DEFAULT_VALIDATE_LIFETIME = true;
    public static final long DEFAULT_LIFETIME_LEEWAY = 60L;
    public static final boolean DEFAULT_MANDATORY = false;
    public static final boolean DEFAULT_REQUESTABLE_FROM_STS = false;
    protected boolean validateLifetime;
    protected long lifetimeLeeway;
    protected boolean mandatory;
    protected boolean requestableFromSTS;
    protected SSOClaim claim;

    public ClaimPolicy() {
    }

    public ClaimPolicy(ClaimPolicy other) {
        super(other);
        this.validateLifetime = other.validateLifetime;
        this.lifetimeLeeway = other.lifetimeLeeway;
        this.mandatory = other.mandatory;
        this.requestableFromSTS = other.requestableFromSTS;
        this.claim = other.claim != null ? (SSOClaim)other.claim.clone() : null;
    }

    public ClaimPolicy(SAML1Policy contextPolicy) {
        super(contextPolicy);
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public void reset() {
        this.validateLifetime = true;
        this.lifetimeLeeway = 60L;
        this.mandatory = false;
        this.requestableFromSTS = false;
        this.claim = SSOTokenFactory.createSSOClaim();
    }

    public static boolean getIsEnforcedByDefault() {
        return true;
    }

    public boolean getValidateLifetime() {
        return this.validateLifetime;
    }

    public void setValidateLifetime(boolean validateLifetime) {
        this.validateLifetime = validateLifetime;
    }

    public long getLifetimeLeeway() {
        return this.lifetimeLeeway;
    }

    public void setLifetimeLeeway(long lifetimeLeeway) {
        this.lifetimeLeeway = lifetimeLeeway;
    }

    public boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean getRequestableFromSTS() {
        return this.requestableFromSTS;
    }

    public void setRequestableFromSTS(boolean requestableFromSTS) {
        this.requestableFromSTS = requestableFromSTS;
    }

    public SSOClaim getClaim() {
        return this.claim;
    }

    public void setClaim(SSOClaim claim) {
        this.claim = claim;
    }

    public boolean equals(Object anObject) {
        ClaimPolicy other;
        SSOClaim otherClaim;
        if (anObject instanceof ClaimPolicy && (otherClaim = (other = (ClaimPolicy)anObject).getClaim()) != null && this.getClaim() != null) {
            return this.getClaim().equalName(otherClaim);
        }
        return false;
    }

    public Object clone() {
        return new ClaimPolicy(this);
    }
}

