/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;

public class SubjectConfirmationPolicy
extends BasePolicy
implements Cloneable {
    private static final Logger log = Logger.getLogger(SubjectConfirmationPolicy.class);
    public static final boolean DEFAULT_ENFORCED = true;
    protected Set allowedConfirmationMethods;

    public SubjectConfirmationPolicy() {
    }

    public SubjectConfirmationPolicy(SubjectConfirmationPolicy other) {
        super(other);
        if (other.allowedConfirmationMethods != null) {
            this.allowedConfirmationMethods = new HashSet();
            Iterator it = other.allowedConfirmationMethods.iterator();
            while (it != null && it.hasNext()) {
                this.allowedConfirmationMethods.add(it.next());
            }
        } else {
            this.allowedConfirmationMethods = null;
        }
    }

    public SubjectConfirmationPolicy(SAML1Policy contextPolicy) {
        super(contextPolicy);
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public void reset() {
        this.allowedConfirmationMethods = new HashSet();
    }

    public static boolean getIsEnforcedByDefault() {
        return true;
    }

    public Set getAllowedConformationMethods() {
        return this.allowedConfirmationMethods;
    }

    public void setAllowedConformationMethods(Set allowedConfirmationMethods) {
        this.allowedConfirmationMethods = allowedConfirmationMethods;
    }

    public void addAllowedConformationMethods(String confirmationMethod) {
        if (!this.allowedConfirmationMethods.contains(confirmationMethod)) {
            this.allowedConfirmationMethods.add(confirmationMethod);
        }
    }

    public Object clone() {
        return new SubjectConfirmationPolicy(this);
    }
}

