/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.validator;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.token.SSOTokenValidationResult;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Handler;
import org.eclipse.alf.security.sso.common.token.saml.policy.AuthorityBindingPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.BasePolicyValidator;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLAuthorityBinding;
import org.opensaml.SAMLStatement;

public class AuthorityBindingPolicyValidator
extends BasePolicyValidator {
    private static final Logger log = Logger.getLogger(AuthorityBindingPolicyValidator.class);

    protected boolean isAuthorityValid(QName authorityKind, String authorityLoc, String authorityBinding, AuthorityBindingPolicy authorityBindingPolicy) {
        return true;
    }

    public ExtendedResult validate(SAML1Handler samlHandler, BasePolicy policy) {
        SSOTokenValidationResult result = new SSOTokenValidationResult();
        AuthorityBindingPolicy authorityBindingPolicy = (AuthorityBindingPolicy)policy;
        boolean authorityBindingStatementFound = false;
        boolean validAuthorityFound = false;
        if (authorityBindingPolicy != null) {
            SAMLAssertion assertion = (SAMLAssertion)samlHandler.getNativeObject();
            Iterator statements = assertion.getStatements();
            while (statements.hasNext()) {
                SAMLStatement statement = (SAMLStatement)statements.next();
                if (!(statement instanceof SAMLAuthenticationStatement)) continue;
                Iterator bindings = ((SAMLAuthenticationStatement)statement).getBindings();
                while (bindings.hasNext()) {
                    SAMLAuthorityBinding binding = (SAMLAuthorityBinding)bindings.next();
                    authorityBindingStatementFound = true;
                    QName authorityKind = binding.getAuthorityKind();
                    String authorityLoc = binding.getLocation();
                    String authorityBinding = binding.getBinding();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("SAML validation: processing authority binding: AuthorityKind=" + authorityKind.toString() + ", Location=" + authorityLoc + ", Binding=" + authorityBinding));
                    }
                    if (!this.isAuthorityValid(authorityKind, authorityLoc, authorityBinding, authorityBindingPolicy)) continue;
                    validAuthorityFound = true;
                    break;
                }
                if (!validAuthorityFound) continue;
                break;
            }
        }
        if (!validAuthorityFound && authorityBindingStatementFound) {
            log.info((Object)"SAML validation: invalid authority binding");
            result.setCode(30);
            return result;
        }
        result.setCode(0);
        return result;
    }
}

