/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.SOAPEngineConstants;

public class SOAPHelper {
    private static Logger log = Logger.getLogger(SOAPHelper.class);
    private static final String SAML_ASSERTATION_NS = "urn:oasis:names:tc:SAML:1.0:assertion";
    private static final String SAML_ASSERTION_LN = "Assertion";
    private static final QName SAML_ASSERTATION_QNAME = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");

    public static boolean isSOAPEnvelope(OMElement element) {
        if (element == null) {
            return false;
        }
        if (!element.getLocalName().equals("Envelope")) {
            return false;
        }
        OMNamespace ns = element.getNamespace();
        if (ns == null) {
            ns = element.getDefaultNamespace();
        }
        if (ns == null) {
            return false;
        }
        if (ns.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            return true;
        }
        return ns.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope");
    }

    public static SOAPEnvelope buildSOAPElement(String message) throws SSOException {
        try {
            StringReader stringReader = new StringReader(message);
            XMLStreamReader xmlr = XMLInputFactory.newInstance().createXMLStreamReader(stringReader);
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlr, null);
            return (SOAPEnvelope)builder.getDocumentElement();
        }
        catch (SOAPProcessingException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Non-SOAP request processed");
            }
            return null;
        }
        catch (XMLStreamException e) {
            log.error((Object)"Unexpected exception caught while trying to build SOAP document:", (Throwable)e);
            throw new SSOException("Unexpected error while building SOAP document", e);
        }
        catch (OMException e) {
            log.error((Object)"Unexpected exception caught while trying to build SOAP document:", (Throwable)e);
            throw new SSOException("Unexpected error while building SOAP document", e);
        }
        catch (Exception e) {
            log.error((Object)"Unexpected exception caught while trying to build SOAP document:", (Throwable)e);
            throw new SSOException("Unexpected error while building SOAP document", e);
        }
    }

    public static SOAPEnvelope buildSOAPElement(InputStream inputStream) throws SSOException {
        try {
            XMLStreamReader xmlr = XMLInputFactory.newInstance().createXMLStreamReader(inputStream, "UTF-8");
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlr, null);
            return (SOAPEnvelope)builder.getDocumentElement();
        }
        catch (SOAPProcessingException e) {
            log.debug((Object)"Non-SOAP request processed");
            return null;
        }
        catch (XMLStreamException e) {
            String errorMessage = "Unexpected exception caught while trying to build SOAP document:" + e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException("Unexpected error while building SOAP document", e);
        }
        catch (OMException e) {
            String errorMessage = "Unexpected exception caught while trying to build SOAP document:" + e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException("Unexpected error while building SOAP document", e);
        }
        catch (Exception e) {
            String errorMessage = "Unexpected exception caught while trying to build SOAP document:" + e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException("Unexpected error while building SOAP document", e);
        }
    }

    public static ArrayList extractWSSEHeaders(SOAPEnvelope soapEnvelope, String expectedActor) {
        if (soapEnvelope == null) {
            log.debug((Object)"Empty soap message passed in wsse header extraction routine");
            return null;
        }
        String ns = soapEnvelope.getNamespace().getNamespaceURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(ns)) {
            return SOAPHelper.getWSSEHeadersFromSOAP11(soapEnvelope, expectedActor);
        }
        return SOAPHelper.getWSSEHeadersFromSOAP12(soapEnvelope, expectedActor);
    }

    protected static ArrayList getWSSEHeadersFromSOAP11(SOAPEnvelope soapEnvelope, String expectedActor) {
        ArrayList<SOAPHeaderBlock> retVal = new ArrayList<SOAPHeaderBlock>();
        SOAPHeader soapHeader = soapEnvelope.getHeader();
        if (soapHeader == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Processed message with no header");
            }
            return null;
        }
        ArrayList wsseHeaders = soapHeader.getHeaderBlocksWithNSURI("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (wsseHeaders != null) {
            Iterator it = wsseHeaders.iterator();
            while (it != null && it.hasNext()) {
                SOAPHeaderBlock wsseHeader = (SOAPHeaderBlock)it.next();
                String soapActor = wsseHeader.getRole();
                if (StringHelper.isStringEqualExtendedIgnoreCase(soapActor, "http://schemas.xmlsoap.org/soap/actor/next")) {
                    retVal.add(wsseHeader);
                    continue;
                }
                if (!StringHelper.isStringEqualExtendedIgnoreCase(soapActor, expectedActor)) continue;
                retVal.add(wsseHeader);
            }
        }
        return retVal;
    }

    protected static ArrayList getWSSEHeadersFromSOAP12(SOAPEnvelope soapEnvelope, String expectedRole) {
        ArrayList<SOAPHeaderBlock> retVal = new ArrayList<SOAPHeaderBlock>();
        SOAPHeader soapHeader = soapEnvelope.getHeader();
        if (soapHeader == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Processed message with no header");
            }
            return null;
        }
        ArrayList wsseHeaders = soapHeader.getHeaderBlocksWithNSURI("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        Iterator it = wsseHeaders.iterator();
        if (it != null) {
            while (it.hasNext()) {
                SOAPHeaderBlock wsseHeader = (SOAPHeaderBlock)it.next();
                String soapRole = wsseHeader.getRole();
                if (StringHelper.isStringEqualExtendedIgnoreCase(soapRole, "http://www.w3.org/2003/05/soap-envelope/role/next")) {
                    retVal.add(wsseHeader);
                    continue;
                }
                if (StringHelper.isStringEqualExtendedIgnoreCase(soapRole, "http://www.w3.org/2003/05/soap-envelope/role/none") || StringHelper.isStringEqualExtendedIgnoreCase(soapRole, "http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver") || !StringHelper.isStringEqualExtendedIgnoreCase(soapRole, expectedRole)) continue;
                retVal.add(wsseHeader);
            }
        }
        return retVal;
    }

    public static SSOToken extractSSOTokenFromSOAPMessage(String soapMessage, String actor) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(soapMessage.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Unsupported encoding: " + e.getMessage()));
            return null;
        }
        SOAPEnvelope env = SOAPHelper.buildSOAPEnvelope(is);
        if (env == null) {
            return null;
        }
        return SOAPHelper.extractSSOTokenFromSOAPMessage(env, actor);
    }

    public static SSOToken extractSSOTokenFromSOAPMessage(SOAPEnvelope soapEnvelope, String actor) {
        ArrayList wsseHeaders = SOAPHelper.extractWSSEHeaders(soapEnvelope, actor);
        if (wsseHeaders == null || wsseHeaders.size() == 0) {
            log.warn((Object)("No security headers found for actor \"" + actor + "\""));
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracting security tokens from ALF SSO wsse security header (actor=\"" + actor + "\")"));
        }
        SSOToken ssotoken = null;
        ssotoken = SOAPHelper.extractSSOTokensFromWSSEHeader((SOAPHeaderBlock)wsseHeaders.get(0));
        if (ssotoken == null) {
            log.warn((Object)("No SSO tokens found in SOAP message security header for actor \"" + actor + "\""));
            return null;
        }
        return ssotoken;
    }

    public static SSOToken extractSSOTokensFromWSSEHeader(SOAPHeaderBlock wsseHeaderBlock) {
        OMElement el;
        SSOToken ssotoken = null;
        if (wsseHeaderBlock != null && (el = wsseHeaderBlock.getFirstChildWithName(SAML_ASSERTATION_QNAME)) != null) {
            try {
                ssotoken = SSOTokenFactory.createSSOToken(el);
                el.detach();
            }
            catch (SSOException e) {
                log.error((Object)("Found element that is not understood:" + el.getLocalName()));
            }
        }
        return ssotoken;
    }

    public static boolean isMTOMSOAPProfile(HttpServletRequest req) {
        if (req.getHeader("SOAPAction") == null) {
            return false;
        }
        String typeValue = SOAPHelper.extractContentTypeParam(req.getContentType(), "multipart/related", "type", true);
        if (StringHelper.isBlank(typeValue) || !typeValue.equalsIgnoreCase("application/xop+xml")) {
            return false;
        }
        String startInfo = SOAPHelper.extractContentTypeParam(req.getContentType(), "multipart/related", "start-info", true);
        if (StringHelper.isBlank(typeValue)) {
            return false;
        }
        String chunkContentType = SOAPHelper.extractMIMEMediaType(startInfo);
        return chunkContentType.equalsIgnoreCase("text/xml") || chunkContentType.equalsIgnoreCase("application/soap+xml");
    }

    public static boolean isSOAPRequestProfile(HttpServletRequest req) {
        if (!req.getMethod().equalsIgnoreCase("POST")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Non-SOAP request: not a HTTP/POST request");
            }
            return false;
        }
        if (req.getHeader("SOAPAction") != null) {
            return true;
        }
        String contentType = req.getContentType();
        if (contentType == null) {
            return false;
        }
        String extractedMIMEMediaType = SOAPHelper.extractMIMEMediaType(contentType);
        if (StringHelper.isBlank(extractedMIMEMediaType)) {
            return false;
        }
        if (extractedMIMEMediaType.equalsIgnoreCase("text/xml") || extractedMIMEMediaType.equalsIgnoreCase("application/soap+xml")) {
            return true;
        }
        return SOAPHelper.isMTOMSOAPProfile(req);
    }

    public static String extractMIMEMediaType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int semicolon = contentType.indexOf(59);
        String contentTypeExtracted = null;
        contentTypeExtracted = semicolon >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim();
        return contentTypeExtracted;
    }

    public static String extractContentTypeParam(String contentTypeHeader, String matchMIMEMediaType, String paramName, boolean removeQuotes) {
        try {
            String extractedMIMEMediaType = SOAPHelper.extractMIMEMediaType(contentTypeHeader);
            if (StringHelper.isNotBlank(extractedMIMEMediaType)) {
                boolean hasMoreTokens;
                int start;
                if (matchMIMEMediaType != null && !extractedMIMEMediaType.equalsIgnoreCase(matchMIMEMediaType)) {
                    return null;
                }
                int current = start = 0;
                boolean inQuote = false;
                boolean bl = hasMoreTokens = current < contentTypeHeader.length();
                while (hasMoreTokens) {
                    char c;
                    while ((c = contentTypeHeader.charAt(current++)) != ';' || inQuote) {
                        if (c == '\"') {
                            boolean bl2 = inQuote = !inQuote;
                        }
                        if (current < contentTypeHeader.length()) continue;
                    }
                    hasMoreTokens = current < contentTypeHeader.length();
                    String nextToken = hasMoreTokens ? contentTypeHeader.substring(start, current - 1) : contentTypeHeader.substring(start);
                    start = current;
                    String s = nextToken.trim();
                    int equalsign = s.indexOf(61);
                    if (equalsign < 0) continue;
                    String mtomParamName = s.substring(0, equalsign).trim();
                    String mtomParamValue = s.substring(equalsign + 1).trim();
                    if (!mtomParamName.equalsIgnoreCase(paramName)) continue;
                    if (removeQuotes && mtomParamValue.length() >= 2 && mtomParamValue.charAt(0) == '\"' && mtomParamValue.charAt(mtomParamValue.length() - 1) == '\"') {
                        mtomParamValue = mtomParamValue.substring(1, mtomParamValue.length() - 1);
                    }
                    return mtomParamValue;
                }
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static SOAPEnvelope buildSOAPEnvelopeFromMTOM(HttpServletRequest req, InputStream is) {
        String soapText = "";
        String boundary = SOAPHelper.extractContentTypeParam(req.getContentType(), "multipart/related", "boundary", false);
        String content_id = SOAPHelper.extractContentTypeParam(req.getContentType(), "multipart/related", "start", true);
        BufferedReader in = null;
        boolean haveCharset = false;
        String charEncoding = req.getCharacterEncoding();
        if (Charset.isSupported(charEncoding)) {
            try {
                in = new BufferedReader(new InputStreamReader(is, charEncoding));
                haveCharset = true;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (!haveCharset && Charset.isSupported("UTF-8")) {
            try {
                in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                haveCharset = true;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (!haveCharset) {
            in = new BufferedReader(new InputStreamReader(is));
            haveCharset = true;
        }
        String line = null;
        boolean done = false;
        try {
            while (true) {
                boolean gotoNextChunk;
                block25: {
                    if ((line = in.readLine()) == null) {
                        throw new SSOException("");
                    }
                    if (!line.equals("--" + boundary)) continue;
                    gotoNextChunk = false;
                    while (true) {
                        if ((line = in.readLine()) == null) {
                            throw new SSOException("");
                        }
                        if (line.trim().length() == 0) break block25;
                        int colon = line.indexOf(58);
                        if (colon < 0 || colon + 2 >= line.length()) {
                            throw new SSOException("");
                        }
                        String headerName = line.substring(0, colon).trim();
                        String headerValue = line.substring(colon + 1).trim();
                        if (headerName.equalsIgnoreCase("content-id") && !headerValue.equals(content_id)) {
                            gotoNextChunk = true;
                            break block25;
                        }
                        if (!headerName.equalsIgnoreCase("content-type")) continue;
                        String typeParam = SOAPHelper.extractContentTypeParam(headerValue, "application/xop+xml", "type", true);
                        if (StringHelper.isBlank(typeParam)) {
                            throw new SSOException("");
                        }
                        String chunkContentType = SOAPHelper.extractMIMEMediaType(typeParam);
                        if (!chunkContentType.equalsIgnoreCase("text/xml") && !chunkContentType.equalsIgnoreCase("application/soap+xml")) break;
                    }
                    throw new SSOException("");
                }
                if (gotoNextChunk) continue;
                while (true) {
                    if ((line = in.readLine()) == null) {
                        throw new SSOException("");
                    }
                    if (line.trim().length() == 0 || line.equals("--" + boundary + "--")) break;
                    soapText = soapText + line;
                }
                done = true;
                if (done) break;
            }
        }
        catch (IOException e) {
            log.error((Object)"Error building SOAP envelope from input stream", (Throwable)e);
            return null;
        }
        catch (SSOException e) {
            log.error((Object)"Error building SOAP envelope from input stream", (Throwable)e);
            return null;
        }
        try {
            SOAPEnvelope soapEnvelope = SOAPHelper.buildSOAPElement(soapText);
            if (soapEnvelope == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Non-SOAP request: failed to build SOAP envelope");
                }
                return null;
            }
            return soapEnvelope;
        }
        catch (IllegalStateException e) {
            log.error((Object)"Error building SOAP envelope from input stream", (Throwable)e);
            return null;
        }
        catch (SSOException e) {
            log.error((Object)"Error building SOAP envelope from input stream", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Error building SOAP envelope from input stream", (Throwable)e);
            return null;
        }
    }

    public static SOAPEnvelope buildSOAPEnvelope(InputStream is) {
        try {
            SOAPEnvelope soapEnvelope = SOAPHelper.buildSOAPElement(is);
            if (soapEnvelope == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Non-SOAP request: failed to build SOAP envelope");
                }
                return null;
            }
            return soapEnvelope;
        }
        catch (IllegalStateException e) {
            log.error((Object)"Error building SOAP envelope from input stream", (Throwable)e);
            return null;
        }
        catch (SSOException e) {
            log.error((Object)"Error building SOAP envelope from input stream", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Error building SOAP envelope from input stream", (Throwable)e);
            return null;
        }
    }

    public static String extractSerializedSOAPMessage(OMElement response) {
        if (response == null) {
            log.error((Object)"Bad argument");
            throw new NullPointerException();
        }
        String decodedMessage = null;
        if (response.getQName().equals(SOAPEngineConstants.SOAP_SERIALIZATION_RESP_QNAME)) {
            String b64message = response.getText().trim();
            decodedMessage = SSOHelper.B64Decode(b64message);
        }
        return decodedMessage;
    }

    public static String extractSOAPAction(HttpServletRequest req, SOAPEnvelope envelope) {
        String mimeMediaType;
        String soapAction = null;
        SOAPHeader soapHeader = envelope.getHeader();
        if (soapHeader != null) {
            OMElement actionEl = soapHeader.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Action"));
            if (actionEl == null) {
                actionEl = soapHeader.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "Action"));
            }
            if (actionEl == null) {
                actionEl = soapHeader.getFirstChildWithName(new QName("http://www.w3.org/2005/08/addressing", "Action"));
            }
            if (actionEl != null) {
                soapAction = actionEl.getText().trim();
            }
        }
        if (StringHelper.isBlank(soapAction) && StringHelper.isNotBlank(mimeMediaType = SOAPHelper.extractMIMEMediaType(req.getContentType()))) {
            if (mimeMediaType.equalsIgnoreCase("text/xml")) {
                soapAction = StringHelper.unQuoteString(req.getHeader("SOAPAction"), '\"');
            } else if (mimeMediaType.equalsIgnoreCase("application/soap+xml")) {
                soapAction = SOAPHelper.extractContentTypeParam(req.getContentType(), "application/soap+xml", "action", true);
            } else if (mimeMediaType.equalsIgnoreCase("multipart/related")) {
                String typeValue = SOAPHelper.extractContentTypeParam(req.getContentType(), "multipart/related", "type", true);
                if (StringHelper.isBlank(typeValue) || typeValue.equalsIgnoreCase("application/xop+xml")) {
                    String startInfo = SOAPHelper.extractContentTypeParam(req.getContentType(), "multipart/related", "start-info", true);
                    if (StringHelper.isNotBlank(typeValue)) {
                        String chunkContentType = SOAPHelper.extractMIMEMediaType(startInfo);
                        if (chunkContentType.equalsIgnoreCase("text/xml")) {
                            soapAction = StringHelper.unQuoteString(req.getHeader("SOAPAction"), '\"');
                        } else if (chunkContentType.equalsIgnoreCase("application/soap+xml")) {
                            soapAction = SOAPHelper.extractContentTypeParam(startInfo, "application/soap+xml", "action", true);
                        }
                    }
                }
                soapAction = StringHelper.unQuoteString(req.getHeader("SOAPAction"), '\"');
            }
        }
        return soapAction;
    }
}

