/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.util;

import org.apache.log4j.Logger;

public class StringHelper {
    private static final Logger log = Logger.getLogger(StringHelper.class);

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isNotBlank(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static String toNotNullString(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public static boolean isStringEqualExtendedIgnoreCase(String s1, String s2) {
        return (s2 == null || s2.length() == 0) && (s1 == null || s1.length() == 0) || s2 != null && s1 != null && s2.equalsIgnoreCase(s1);
    }

    public static String unQuoteString(String s, char quote) {
        if (StringHelper.isBlank(s)) {
            return s;
        }
        if (s.length() < 2) {
            return s;
        }
        if (s.charAt(0) != quote || s.charAt(s.length() - 1) != quote) {
            return s;
        }
        return s.substring(1, s.length() - 1);
    }

    public static int calcHash(String s) {
        if (s == null) {
            return 0;
        }
        int hash = 0;
        int numChar = s.length();
        for (int i = 0; i < numChar; ++i) {
            hash = 31 * hash + s.charAt(i);
        }
        return hash;
    }

    public static String simpleStringReplace(String aInput, String aOldPattern, String aNewPattern) {
        if (aOldPattern.equals("")) {
            throw new IllegalArgumentException("Old pattern must have content.");
        }
        StringBuffer result = new StringBuffer();
        int startIdx = 0;
        int idxOld = 0;
        while ((idxOld = aInput.indexOf(aOldPattern, startIdx)) >= 0) {
            result.append(aInput.substring(startIdx, idxOld));
            result.append(aNewPattern);
            startIdx = idxOld + aOldPattern.length();
        }
        result.append(aInput.substring(startIdx));
        return result.toString();
    }

    public static boolean basicWildcardMatch(String pattern, String string) {
        return StringHelper.basicWildcardMatch(pattern, string, 0, 0);
    }

    private static boolean basicWildcardMatch(String pattern, String string, int patternStartIndex, int stringStartIndex) {
        int patternIndex = patternStartIndex;
        int stringIndex = stringStartIndex;
        int patternLength = pattern.length();
        int stringLength = string.length();
        boolean nextIsNotWildcard = false;
        while (true) {
            if (stringIndex >= stringLength) {
                while (patternIndex < patternLength && pattern.charAt(patternIndex) == '*') {
                    ++patternIndex;
                }
                return patternIndex >= patternLength;
            }
            if (patternIndex >= patternLength) {
                return false;
            }
            char c = pattern.charAt(patternIndex);
            if (!nextIsNotWildcard) {
                if (c == '\\') {
                    ++patternIndex;
                    nextIsNotWildcard = true;
                    continue;
                }
                if (c == '?') {
                    ++stringIndex;
                    ++patternIndex;
                    continue;
                }
                if (c == '*') {
                    int cc = 0;
                    if (patternIndex + 1 < patternLength) {
                        cc = pattern.charAt(patternIndex + 1);
                    }
                    if (cc == 42) {
                        ++patternIndex;
                        continue;
                    }
                    ++patternIndex;
                    for (int i = string.length(); i >= stringIndex; --i) {
                        if (!StringHelper.basicWildcardMatch(pattern, string, patternIndex, i)) continue;
                        return true;
                    }
                    return false;
                }
            } else {
                nextIsNotWildcard = false;
            }
            if (c != string.charAt(stringIndex)) {
                return false;
            }
            ++stringIndex;
            ++patternIndex;
        }
    }

    public static int basicWildcardMatchWithMatchScore(String pattern, String string) {
        return StringHelper.basicWildcardMatchWithMatchScore(pattern, string, 0, 0);
    }

    private static int basicWildcardMatchWithMatchScore(String pattern, String string, int patternStartIndex, int stringStartIndex) {
        int patternIndex = patternStartIndex;
        int stringIndex = stringStartIndex;
        int patternLength = pattern.length();
        int stringLength = string.length();
        boolean nextIsNotWildcard = false;
        int matchcount = 1;
        while (true) {
            if (stringIndex >= stringLength) {
                while (patternIndex < patternLength && pattern.charAt(patternIndex) == '*') {
                    ++patternIndex;
                }
                return patternIndex >= patternLength ? matchcount : -matchcount;
            }
            if (patternIndex >= patternLength) {
                return -matchcount;
            }
            char c = pattern.charAt(patternIndex);
            if (!nextIsNotWildcard) {
                if (c == '\\') {
                    ++patternIndex;
                    nextIsNotWildcard = true;
                    continue;
                }
                if (c == '?') {
                    ++stringIndex;
                    ++patternIndex;
                    continue;
                }
                if (c == '*') {
                    int cc = 0;
                    if (patternIndex + 1 < patternLength) {
                        cc = pattern.charAt(patternIndex + 1);
                    }
                    if (cc == 42) {
                        ++patternIndex;
                        continue;
                    }
                    ++patternIndex;
                    for (int i = string.length(); i >= stringIndex; --i) {
                        int recursiveMatchCount = StringHelper.basicWildcardMatchWithMatchScore(pattern, string, patternIndex, i);
                        if (recursiveMatchCount < 0) continue;
                        return matchcount + recursiveMatchCount;
                    }
                    return -matchcount;
                }
            } else {
                nextIsNotWildcard = false;
            }
            if (c != string.charAt(stringIndex)) {
                return -matchcount;
            }
            ++stringIndex;
            ++patternIndex;
            ++matchcount;
        }
    }

    static {
        log.isDebugEnabled();
    }
}

