/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl;

import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.GenericAttribute;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExt;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.KeyIdentifier;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl.BaseWSSecExtObjectImpl;

public class KeyIdentifierImpl
extends BaseWSSecExtObjectImpl
implements KeyIdentifier {
    private static final Logger log = Logger.getLogger(KeyIdentifierImpl.class);
    protected WSSecExt wsse;
    protected String id;
    protected String encodingType;
    protected String valueType;
    protected String value;

    public KeyIdentifierImpl() {
        this.reset();
        this.wsse = new WSSecExt();
    }

    public KeyIdentifierImpl(WSSecExt wsse) {
        this.reset();
        this.wsse = wsse;
    }

    public void reset() {
        super.reset();
        this.id = null;
        this.encodingType = null;
        this.valueType = null;
        this.value = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof KeyIdentifierImpl) {
            KeyIdentifierImpl otherKeyIdentifierImpl = (KeyIdentifierImpl)other;
            this.wsse = otherKeyIdentifierImpl.wsse;
            this.id = otherKeyIdentifierImpl.id;
            this.encodingType = otherKeyIdentifierImpl.encodingType;
            this.valueType = otherKeyIdentifierImpl.valueType;
            this.value = otherKeyIdentifierImpl.value;
        }
    }

    public String getLocalName() {
        return "KeyIdentifier";
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public String getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
        this.setDirty();
    }

    public void setId(String id) {
        this.id = id;
        this.setDirty();
    }

    public void setValue(String value) {
        this.value = value;
        this.setDirty();
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
        this.setDirty();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        return null;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementSecExt(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        WSSecExt wsse = this.baseIsCompatibleElementSecExt(element, this.getLocalName());
        if (wsse == null) {
            return null;
        }
        log.debug((Object)"Parsing <wsse:KeyReference> element");
        KeyIdentifierImpl keyIdentifier = new KeyIdentifierImpl(wsse);
        Iterator it = element.getAllAttributes();
        if (it != null) {
            while (it.hasNext()) {
                OMAttribute attr = (OMAttribute)it.next();
                if (attr.getLocalName().equals("Id")) {
                    keyIdentifier.id = attr.getAttributeValue();
                    continue;
                }
                if (attr.getLocalName().equals("ValueType")) {
                    keyIdentifier.valueType = attr.getAttributeValue();
                    continue;
                }
                if (attr.getLocalName().equals("EncodingType")) {
                    keyIdentifier.encodingType = attr.getAttributeValue();
                    continue;
                }
                keyIdentifier._anyAttr.add(new GenericAttribute(attr.getLocalName(), attr.getAttributeValue()));
            }
        }
        keyIdentifier.value = element.getText();
        keyIdentifier.setParseSource(element);
        this.copyFrom(keyIdentifier);
        return this;
    }
}

