/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.security.secext.token.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.Base64;
import org.apache.log4j.Logger;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.UIDGenerator;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.GenericAttribute;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExt;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExtVersion;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl.BaseWSSecExtObjectImpl;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.UsernameToken;
import org.eclipse.alf.security.sso.common.ws.model.security.utility.WSSecUtility;
import org.eclipse.alf.security.sso.common.ws.model.security.utility.WSSecUtilityObjectBuilder;

public class UsernameTokenImpl
extends BaseWSSecExtObjectImpl
implements UsernameToken {
    private static final Logger log = Logger.getLogger(UsernameTokenImpl.class);
    protected WSSecExt wsse;
    protected String id;
    protected byte[] nonceValue;
    protected byte[] saltValue;
    protected Date created;
    protected Boolean addCreatedInMilliseconds;
    protected String username;
    protected String password;
    protected boolean passwordHashed;
    protected Integer iteration;
    protected static SecureRandom random;

    public UsernameTokenImpl() {
        this.reset();
        this.wsse = new WSSecExt();
    }

    public UsernameTokenImpl(WSSecExt wsse) {
        this.reset();
        this.wsse = wsse;
    }

    public UsernameTokenImpl(String username, String password) {
        this.reset();
        this.wsse = new WSSecExt();
        this.username = username;
        this.password = password;
    }

    public UsernameTokenImpl(WSSecExt wsse, String username, String password) {
        this.reset();
        this.wsse = wsse;
        this.username = username;
        this.password = password;
    }

    public String getLocalName() {
        return "UsernameToken";
    }

    public void reset() {
        super.reset();
        this.id = null;
        this.created = null;
        this.nonceValue = null;
        this.saltValue = null;
        this.addCreatedInMilliseconds = null;
        this.username = null;
        this.password = null;
        this.passwordHashed = false;
        this.iteration = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof UsernameTokenImpl) {
            UsernameTokenImpl otherUsernameTokenImpl = (UsernameTokenImpl)other;
            this.wsse = otherUsernameTokenImpl.wsse;
            this.id = otherUsernameTokenImpl.id;
            this.created = otherUsernameTokenImpl.created;
            this.nonceValue = otherUsernameTokenImpl.nonceValue;
            this.saltValue = otherUsernameTokenImpl.saltValue;
            this.addCreatedInMilliseconds = otherUsernameTokenImpl.addCreatedInMilliseconds;
            this.username = otherUsernameTokenImpl.username;
            this.password = otherUsernameTokenImpl.password;
            this.passwordHashed = otherUsernameTokenImpl.passwordHashed;
            this.iteration = otherUsernameTokenImpl.iteration;
        }
    }

    public String getIssuer() {
        return null;
    }

    public String getType() {
        return "UsernameToken";
    }

    public final Object getNativeObject() {
        return this;
    }

    public String addId() {
        this.id = UIDGenerator.getUUID();
        this.setDirty();
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.setDirty();
    }

    public Date getCreated() {
        return this.created;
    }

    public byte[] addNonce() {
        this.nonceValue = new byte[16];
        random.nextBytes(this.nonceValue);
        this.setDirty();
        return this.nonceValue;
    }

    public void setNonce(byte[] nonceValue) {
        this.nonceValue = nonceValue;
        this.setDirty();
    }

    public byte[] getNonce() {
        return this.nonceValue;
    }

    public void addCreated() {
        this.addCreatedInMilliseconds = Boolean.TRUE;
        this.setDirty();
    }

    public void addCreated(boolean milliseconds) {
        this.addCreatedInMilliseconds = milliseconds ? Boolean.TRUE : Boolean.FALSE;
        this.setDirty();
    }

    public void clearCreated() {
        this.addCreatedInMilliseconds = null;
        this.setDirty();
    }

    public boolean getAddCreated() {
        return this.addCreatedInMilliseconds == null;
    }

    public byte[] addSalt(byte[] saltValue, boolean mac) {
        this.saltValue = saltValue == null ? UsernameTokenImpl.generateSalt(mac) : saltValue;
        this.setDirty();
        return this.saltValue;
    }

    public void clearSalt() {
        this.saltValue = null;
        this.setDirty();
    }

    public byte[] getSalt() {
        return this.saltValue;
    }

    public void setIteration(Integer iteration) {
        this.iteration = iteration;
        this.setDirty();
    }

    public Integer getIteration() {
        return this.iteration;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (username == null) {
            throw new NullPointerException("parameter cannot be null");
        }
        this.username = username;
        this.setDirty();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.setDirty();
    }

    public void setPassword(String password, boolean hashPassword) {
        if (!hashPassword) {
            this.password = password;
        }
        this.setDirty();
    }

    public boolean isPasswordHashed() {
        return this.passwordHashed;
    }

    protected static String calcPasswordDigest(byte[] nonce, String cr, String pw) {
        String passwdDigest = null;
        try {
            byte[] b1 = nonce;
            byte[] b2 = cr.getBytes("UTF-8");
            byte[] b3 = pw.getBytes("UTF-8");
            byte[] b4 = new byte[b1.length + b2.length + b3.length];
            int offset = 0;
            System.arraycopy(b1, 0, b4, offset, b1.length);
            System.arraycopy(b2, 0, b4, offset += b1.length, b2.length);
            System.arraycopy(b3, 0, b4, offset += b2.length, b3.length);
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            sha.reset();
            sha.update(b4);
            passwdDigest = Base64.encode((byte[])sha.digest());
        }
        catch (Exception e) {
            log.error((Object)"Exception computing password SHA-1 digest", (Throwable)e);
        }
        return passwdDigest;
    }

    protected static byte[] generateSalt(boolean useForMac) {
        byte[] saltValue = new byte[16];
        random.nextBytes(saltValue);
        saltValue[15] = useForMac ? 1 : 2;
        return saltValue;
    }

    protected static String createTimestamp(boolean milliseconds) {
        Object zulu = null;
        if (milliseconds) {
            zulu = new XmlSchemaDateFormat();
        } else {
            zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            ((DateFormat)zulu).setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        Calendar rightNow = Calendar.getInstance();
        String created = ((DateFormat)zulu).format(rightNow.getTime());
        return created;
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        boolean milliseconds = true;
        if (this.addCreatedInMilliseconds != null) {
            milliseconds = this.addCreatedInMilliseconds;
        }
        String created = UsernameTokenImpl.createTimestamp(milliseconds);
        if (this.passwordHashed) {
            String pwDigest;
            this.password = pwDigest = UsernameTokenImpl.calcPasswordDigest(this.nonceValue, created, this.password);
        }
        OMNamespace wsse10NS = WSSecExt.getNamespace(WSSecExtVersion.V10);
        OMNamespace wsse11NS = WSSecExt.getNamespace(WSSecExtVersion.V11);
        OMNamespace wsuNS = WSSecUtility.getWSUOMNamespace();
        OMElement usernameTokenEl = WSSecExt.createOMElement(WSSecExtVersion.V10, this.getLocalName());
        if (this.id != null) {
            usernameTokenEl.addAttribute("Id", this.id, WSSecUtility.getWSUOMNamespace());
        }
        OMElement usernameEl = XMLHelper.createOMElement(usernameTokenEl, wsse10NS, "Username");
        usernameEl.setText(this.username);
        usernameTokenEl.addChild((OMNode)usernameEl);
        if (this.password != null) {
            OMElement passwordEl = XMLHelper.createOMElement(usernameTokenEl, wsse10NS, "Password");
            if (this.passwordHashed) {
                passwordEl.addAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest", wsse10NS);
            } else {
                passwordEl.addAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText", wsse10NS);
            }
            passwordEl.setText(this.password);
            usernameTokenEl.addChild((OMNode)passwordEl);
        }
        if (this.nonceValue != null) {
            OMElement nonceEl = XMLHelper.createOMElement(usernameTokenEl, wsse10NS, "Nonce");
            nonceEl.setText(Base64.encode((byte[])this.nonceValue));
            usernameTokenEl.addChild((OMNode)nonceEl);
        }
        if (this.addCreatedInMilliseconds != null) {
            OMElement createdEl = XMLHelper.createOMElement(usernameTokenEl, wsuNS, "Created");
            createdEl.setText(created);
            usernameTokenEl.addChild((OMNode)createdEl);
        }
        if (this.saltValue != null) {
            OMElement saltEl = XMLHelper.createOMElement(usernameTokenEl, wsse11NS, "Salt");
            saltEl.setText(Base64.encode((byte[])this.saltValue));
            usernameTokenEl.addChild((OMNode)saltEl);
        }
        if (this.iteration != null) {
            OMElement iterationEl = XMLHelper.createOMElement(usernameTokenEl, wsse11NS, "Iteration");
            iterationEl.setText(this.iteration.toString());
            usernameTokenEl.addChild((OMNode)iterationEl);
        }
        if (parent != null) {
            parent.addChild((OMNode)usernameTokenEl);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + usernameTokenEl.toString() + "]"));
        }
        return usernameTokenEl;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementSecExt(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        WSSecExt wsse = this.baseIsCompatibleElementSecExt(element, this.getLocalName());
        if (wsse == null) {
            return null;
        }
        UsernameTokenImpl usernameToken = new UsernameTokenImpl(wsse);
        Iterator it = element.getAllAttributes();
        while (it.hasNext()) {
            OMAttribute attr = (OMAttribute)it.next();
            QName idQname = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
            if (attr.getQName().equals(idQname)) {
                usernameToken.id = attr.getAttributeValue();
            }
            usernameToken._anyAttr.add(new GenericAttribute(attr.getLocalName(), attr.getAttributeValue()));
        }
        it = element.getChildElements();
        if (it != null) {
            while (it.hasNext()) {
                OMElement workEl = (OMElement)it.next();
                String localName = workEl.getLocalName();
                if ("Username".equals(localName)) {
                    usernameToken.username = workEl.getText();
                    continue;
                }
                if ("Password".equals(localName)) {
                    usernameToken.password = workEl.getText();
                    QName passTypeQNAME = new QName(wsse.getNamespace(), "Type");
                    OMAttribute passTypeAttr = workEl.getAttribute(passTypeQNAME);
                    if (passTypeAttr == null) {
                        usernameToken.passwordHashed = false;
                        continue;
                    }
                    String passType = passTypeAttr.getAttributeValue();
                    if (passType == null || passType.trim().length() == 0) {
                        log.error((Object)"Invalud <wsse:UsernameToken> profile: passtype is empty");
                        throw new SSOException("Invalud UsernameToken profile: passtype is empty");
                    }
                    if (passType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText")) {
                        usernameToken.passwordHashed = false;
                        continue;
                    }
                    if (passType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest")) {
                        usernameToken.passwordHashed = true;
                        continue;
                    }
                    log.error((Object)("Invalud <wsse:UsernameToken> profile: unrecognized password type:" + passType));
                    throw new SSOException("Invalud UsernameToken profile: unrecognized password type:" + passType);
                }
                if ("Nonce".equals(localName)) {
                    QName encodingTypeQNAME = new QName(wsse.getNamespace(), "EncodingType");
                    OMAttribute encodingTypeAttr = workEl.getAttribute(encodingTypeQNAME);
                    if (encodingTypeAttr == null) {
                        usernameToken.nonceValue = Base64.decode((String)element.getText());
                        continue;
                    }
                    log.error((Object)("Invalud <wsse:UsernameToken> profile: unrecognized nonce encoding type:" + encodingTypeAttr.getAttributeValue()));
                    throw new SSOException("Invalud UsernameToken profile: unrecognized nonce encoding type:" + encodingTypeAttr.getAttributeValue());
                }
                if ("Created".equals(localName)) {
                    usernameToken.created = WSSecUtilityObjectBuilder.buildCreated(workEl).getCreated();
                    continue;
                }
                usernameToken._anyElement.add(workEl.cloneOMElement());
            }
        }
        usernameToken.setParseSource(element);
        this.copyFrom(usernameToken);
        return this;
    }

    static {
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e);
        }
    }
}

