/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.security.utility;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.model.security.utility.WSSecUtilityObjectFactory;

public class WSSecUtility {
    static final Logger log = Logger.getLogger(WSSecUtility.class);
    public static final String WSU_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    public static final String WSU_DEFAULT_PREFIX = "wsu";
    protected static WSSecUtilityObjectFactory objectFactory = new WSSecUtilityObjectFactory();

    public static OMNamespace getWSUOMNamespace() {
        return OMAbstractFactory.getOMFactory().createOMNamespace(WSU_NAMESPACE, WSU_DEFAULT_PREFIX);
    }

    public static boolean isSupportedNamespace(String namespace) {
        return namespace.equals(WSU_NAMESPACE);
    }

    public static WSSecUtilityObjectFactory getObjectFactory() {
        return objectFactory;
    }

    public static OMElement createOMElement(String elementLocalName) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        return fac.createOMElement(elementLocalName, WSU_NAMESPACE, WSU_DEFAULT_PREFIX);
    }

    public static OMElement createOMElement(OMElement parent, String elementLocalName) {
        if (parent == null) {
            OMFactory fac = OMAbstractFactory.getOMFactory();
            return fac.createOMElement(elementLocalName, WSU_NAMESPACE, WSU_DEFAULT_PREFIX);
        }
        return XMLHelper.createOMElement(parent, WSU_NAMESPACE, elementLocalName, WSU_DEFAULT_PREFIX);
    }

    public static class AttributeNames {
        public static final String ID = "Id";
    }

    public static class ElementNames {
        public static final String CREATED = "Created";
        public static final String EXPIRES = "Expires";
    }
}

