/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.AuthenticationType;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.BaseWSTrustObjectImpl;

public class AuthenticationTypeImpl
extends BaseWSTrustObjectImpl
implements AuthenticationType {
    private static final Logger log = Logger.getLogger(AuthenticationTypeImpl.class);
    protected WSTrust wst;
    protected String authenticationType;

    public AuthenticationTypeImpl() {
        this.reset();
        this.wst = new WSTrust();
    }

    public AuthenticationTypeImpl(WSTrust wst) {
        this.reset();
        this.wst = wst;
    }

    public AuthenticationTypeImpl(WSTrust wst, String authenticationType) {
        this.reset();
        this.wst = wst;
        this.authenticationType = authenticationType;
    }

    public String getLocalName() {
        return "AuthenticationType";
    }

    public void reset() {
        super.reset();
        this.authenticationType = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof AuthenticationTypeImpl) {
            AuthenticationTypeImpl otherAuthenticationTypeImpl = (AuthenticationTypeImpl)other;
            this.wst = otherAuthenticationTypeImpl.wst;
            this.authenticationType = otherAuthenticationTypeImpl.authenticationType;
        }
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
        this.setDirty();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement authenticationTypeEl = this.wst.createOMElement(parent, this.getLocalName());
        authenticationTypeEl.setText(this.authenticationType);
        this.addAnyAttributesToElement(authenticationTypeEl);
        this.addAnyElementsToElementAsChildren(authenticationTypeEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + authenticationTypeEl.toString() + "]"));
        }
        return authenticationTypeEl;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementTrust(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        throw new SSOException("Not implemented method");
    }

    public WSTrust getWSTrust() {
        return this.wst;
    }
}

