/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.GenericAttribute;
import org.eclipse.alf.security.sso.common.ws.model.policy.WSPolicyObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.policy.element.AppliesTo;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustVersion;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.BinarySecret;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.CancelTarget;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Claims;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Lifetime;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.OnBehalfOf;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RenewTarget;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestType;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.SecondaryParameters;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.TokenType;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.ValidateTarget;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.BaseWSTrustObjectImpl;

public class SecondaryParametersImpl
extends BaseWSTrustObjectImpl
implements SecondaryParameters {
    private static final Logger log = Logger.getLogger(SecondaryParametersImpl.class);
    protected WSTrust wst;
    protected ArrayList secondaryParameters;

    public SecondaryParametersImpl() {
        this.reset();
        this.wst = new WSTrust(WSTrustVersion.V3);
    }

    public SecondaryParametersImpl(WSTrust wst) {
        this.reset();
        this.wst = wst;
    }

    public String getLocalName() {
        return "SecondaryParameters";
    }

    public void reset() {
        super.reset();
        this.secondaryParameters = new ArrayList();
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof SecondaryParametersImpl) {
            SecondaryParametersImpl otherSecondaryParametersImpl = (SecondaryParametersImpl)other;
            this.wst = otherSecondaryParametersImpl.wst;
            this.secondaryParameters = otherSecondaryParametersImpl.secondaryParameters;
        }
    }

    public ArrayList getSecondaryParameters() {
        return this.secondaryParameters;
    }

    public void addSecondaryParameter(BaseWSInterface secondaryParameter) {
        this.secondaryParameters.add(secondaryParameter);
    }

    public void clearSecondaryParameters() {
        this.secondaryParameters.clear();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        Iterator it;
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement secondaryParametersEl = this.wst.createOMElement(parent, this.getLocalName());
        if (this.secondaryParameters != null && this.secondaryParameters.size() > 0 && (it = this.secondaryParameters.iterator()) != null) {
            while (it.hasNext()) {
                Object current = it.next();
                if (!(current instanceof BaseWSInterface)) continue;
                BaseWSInterface currentWSObject = (BaseWSInterface)current;
                parent.addChild((OMNode)currentWSObject.toOM());
            }
        }
        this.addAnyAttributesToElement(secondaryParametersEl);
        this.addAnyElementsToElementAsChildren(secondaryParametersEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + secondaryParametersEl.toString() + "]"));
        }
        return secondaryParametersEl;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementTrust(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        WSTrust wst = this.baseIsCompatibleElementTrust(element, this.getLocalName());
        if (wst == null) {
            return null;
        }
        log.debug((Object)"Parsing <wst:SecondaryParameters> element");
        SecondaryParametersImpl secondaryParameters = new SecondaryParametersImpl(wst);
        Iterator it = element.getAllAttributes();
        while (it.hasNext()) {
            OMAttribute attr = (OMAttribute)it.next();
            secondaryParameters._anyAttr.add(new GenericAttribute(attr.getLocalName(), attr.getAttributeValue()));
        }
        it = element.getChildElements();
        if (it != null) {
            while (it != null && it.hasNext()) {
                OMElement workEl = (OMElement)it.next();
                String localName = workEl.getLocalName();
                if ("RequestType".equals(localName)) {
                    RequestType requestType = WSTrustObjectBuilder.buildRequestType(workEl);
                    secondaryParameters.addSecondaryParameter(requestType);
                    continue;
                }
                if ("BinarySecret".equals(localName)) {
                    BinarySecret binarySecret = WSTrustObjectBuilder.buildBinarySecret(workEl);
                    secondaryParameters.addSecondaryParameter(binarySecret);
                    continue;
                }
                if ("TokenType".equals(localName)) {
                    TokenType tokenType = WSTrustObjectBuilder.buildTokenType(workEl);
                    secondaryParameters.addSecondaryParameter(tokenType);
                    continue;
                }
                if ("AppliesTo".equals(localName)) {
                    AppliesTo appliesTo = WSPolicyObjectBuilder.buildAppliesTo(workEl);
                    secondaryParameters.addSecondaryParameter(appliesTo);
                    continue;
                }
                if ("Lifetime".equals(localName)) {
                    Lifetime lifetime = WSTrustObjectBuilder.buildLifetime(workEl);
                    secondaryParameters.addSecondaryParameter(lifetime);
                    continue;
                }
                if ("OnBehalfOf".equals(localName)) {
                    OnBehalfOf onBehalfOf = WSTrustObjectBuilder.buildOnBehalfOf(workEl);
                    secondaryParameters.addSecondaryParameter(onBehalfOf);
                    continue;
                }
                if ("CancelTarget".equals(localName)) {
                    CancelTarget cancelTarget = WSTrustObjectBuilder.buildCancelTarget(workEl);
                    secondaryParameters.addSecondaryParameter(cancelTarget);
                    continue;
                }
                if ("RenewTarget".equals(localName)) {
                    RenewTarget renewTarget = WSTrustObjectBuilder.buildRenewTarget(workEl);
                    secondaryParameters.addSecondaryParameter(renewTarget);
                    continue;
                }
                if ("ValidateTarget".equals(localName)) {
                    ValidateTarget validateTarget = WSTrustObjectBuilder.buildValidateTarget(workEl);
                    secondaryParameters.addSecondaryParameter(validateTarget);
                    continue;
                }
                if ("Claims".equals(localName)) {
                    Claims claims = WSTrustObjectBuilder.buildClaims(workEl);
                    secondaryParameters.addSecondaryParameter(claims);
                    continue;
                }
                if ("SecondaryParameters".equals(localName)) continue;
                secondaryParameters._anyElement.add(workEl.cloneOMElement());
            }
        }
        this.setParseSource(element);
        this.copyFrom(secondaryParameters);
        return this;
    }

    public WSTrust getWSTrust() {
        return this.wst;
    }
}

