/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.keystore;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProvider;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class KeystoreProviderRegistry
implements Cloneable {
    private static final Logger log = Logger.getLogger(KeystoreProviderRegistry.class);
    private HashMap keystores = new HashMap();

    public KeystoreProviderRegistry() {
        this.reset();
    }

    public KeystoreProviderRegistry(KeystoreProviderRegistry other) {
        this.reset();
        for (String key : other.keystores.keySet()) {
            KeystoreProvider value = (KeystoreProvider)other.keystores.get(key);
            KeystoreProvider newValue = (KeystoreProvider)value.clone();
            this.keystores.put(key, newValue);
        }
    }

    public void reset() {
        this.keystores = new HashMap();
    }

    public KeystoreProvider getKeystoreProvider(String keystoreName) {
        if (StringHelper.isBlank(keystoreName)) {
            return null;
        }
        return (KeystoreProvider)this.keystores.get(keystoreName);
    }

    public void addOrReplaceKeystoreProvider(KeystoreProvider newKeystoreProvider) {
        if (newKeystoreProvider != null) {
            KeystoreProvider oldKeystoreProvider = (KeystoreProvider)this.keystores.get(newKeystoreProvider.getId());
            if (oldKeystoreProvider != null) {
                if (newKeystoreProvider.getKeystore() == null) {
                    log.debug((Object)"addOrReplaceKeystoreProvider: new keystoreProvider doesn't contain valid keystore. Replace skipped");
                } else {
                    this.keystores.put(newKeystoreProvider.getId(), newKeystoreProvider);
                    log.debug((Object)("addOrReplaceKeystoreProvider: Replacing keystore: " + newKeystoreProvider.getId()));
                }
            } else {
                this.keystores.put(newKeystoreProvider.getId(), newKeystoreProvider);
                log.debug((Object)("addOrReplaceKeystoreProvider: Adding new keystore to the registry: " + newKeystoreProvider.getId()));
            }
        }
    }

    public void addOrReplaceKeystoreRegistry(KeystoreProviderRegistry keystoreProviderRegistry) {
        Iterator it;
        if (keystoreProviderRegistry != null && keystoreProviderRegistry.keystores != null && (it = keystoreProviderRegistry.keystores.values().iterator()) != null) {
            while (it.hasNext()) {
                KeystoreProvider currentKeystoreProvider = (KeystoreProvider)it.next();
                this.addOrReplaceKeystoreProvider(currentKeystoreProvider);
            }
        }
    }

    public Object clone() {
        return new KeystoreProviderRegistry(this);
    }
}

