/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.security.utility.element.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.security.utility.WSSecUtility;
import org.eclipse.alf.security.sso.common.ws.model.security.utility.element.Created;
import org.eclipse.alf.security.sso.common.ws.model.security.utility.element.impl.BaseWSSecUtilitlyObjectImpl;

public class CreatedImpl
extends BaseWSSecUtilitlyObjectImpl
implements Created {
    private static final Logger log = Logger.getLogger(CreatedImpl.class);
    protected Date created;
    protected boolean inMilliseconds;

    public CreatedImpl() {
        this.reset();
    }

    public CreatedImpl(Date created) {
        this.reset();
        this.created = created;
    }

    public String getLocalName() {
        return "Created";
    }

    public void reset() {
        super.reset();
        this.created = null;
        this.inMilliseconds = false;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof CreatedImpl) {
            CreatedImpl otherCreatedImpl = (CreatedImpl)other;
            this.created = otherCreatedImpl.created;
            this.inMilliseconds = otherCreatedImpl.inMilliseconds;
        }
    }

    public void setCreated(Date created) {
        this.created = created;
        this.setDirty();
    }

    public Date getCreated() {
        return this.created;
    }

    public void setInMilliseconds(boolean inMilliseconds) {
        this.inMilliseconds = inMilliseconds;
        this.setDirty();
    }

    public boolean getInMilliseconds() {
        return this.inMilliseconds;
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        SimpleDateFormat zulu = this.inMilliseconds ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        zulu.setTimeZone(TimeZone.getTimeZone("UTC"));
        OMElement createdEl = WSSecUtility.createOMElement(parent, this.getLocalName());
        if (this.created != null) {
            createdEl.setText(zulu.format(this.created));
        } else {
            createdEl.setText("");
        }
        this.addAnyAttributesToElement(createdEl);
        this.addAnyElementsToElementAsChildren(createdEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + createdEl.toString() + "]"));
        }
        return createdEl;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        if (!this.isCompatibleElement(element)) {
            return null;
        }
        CreatedImpl created = new CreatedImpl();
        String createdText = element.getText();
        if (createdText != null && createdText.trim().length() > 0) {
            SimpleDateFormat zulu = null;
            zulu = createdText.indexOf(46) > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            zulu.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                created.setCreated(zulu.parse(createdText));
            }
            catch (ParseException e) {
                log.error((Object)("Error while parsing <wst:Created> data:[" + createdText + "]"), (Throwable)e);
                throw new SSOException("Error parsing timestamp");
            }
        } else {
            log.debug((Object)"<wsu:Created>: empty date encoutntered while parsing");
        }
        created.setParseSource(element);
        this.copyFrom(created);
        return this;
    }
}

