/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.GenericAttribute;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExtObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.SecurityTokenReference;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SignedSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.impl.SAML1TokenImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.ValidateTarget;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.BaseWSTrustObjectImpl;

public class ValidateTargetImpl
extends BaseWSTrustObjectImpl
implements ValidateTarget {
    private static final Logger log = Logger.getLogger(ValidateTargetImpl.class);
    protected WSTrust wst;
    protected SignedSecurityToken securityToken;
    protected SecurityTokenReference securityTokenReference;

    public ValidateTargetImpl() {
        this.reset();
        this.wst = new WSTrust();
    }

    public ValidateTargetImpl(WSTrust wst) {
        this.reset();
        this.wst = wst;
    }

    public String getLocalName() {
        return "ValidateTarget";
    }

    public void reset() {
        super.reset();
        this.securityToken = null;
        this.securityTokenReference = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof ValidateTargetImpl) {
            ValidateTargetImpl otherValidateTargetImpl = (ValidateTargetImpl)other;
            this.wst = otherValidateTargetImpl.wst;
            this.securityToken = otherValidateTargetImpl.securityToken;
            this.securityTokenReference = otherValidateTargetImpl.securityTokenReference;
        }
    }

    public SignedSecurityToken getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(SignedSecurityToken securityToken) {
        this.securityToken = securityToken;
        this.securityTokenReference = null;
        this.setDirty();
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.securityTokenReference;
    }

    public void setSecurityTokenReference(SecurityTokenReference securityTokenReference) {
        this.securityTokenReference = securityTokenReference;
        this.securityToken = null;
        this.setDirty();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement validateTarget = this.wst.createOMElement(parent, this.getLocalName());
        if (this.securityToken != null) {
            this.securityToken.toOM(validateTarget);
        }
        if (this.securityTokenReference != null) {
            this.securityTokenReference.toOM(validateTarget);
        }
        this.addAnyAttributesToElement(validateTarget);
        this.addAnyElementsToElementAsChildren(validateTarget);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + validateTarget.toString() + "]"));
        }
        return validateTarget;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementTrust(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        WSTrust wst = this.baseIsCompatibleElementTrust(element, this.getLocalName());
        if (wst == null) {
            return null;
        }
        log.debug((Object)"Parsing <wst:RequestSecurityToken/ValidateTarget> element");
        ValidateTargetImpl validateTarget = new ValidateTargetImpl(wst);
        Iterator it = element.getAllAttributes();
        if (it != null) {
            while (it.hasNext()) {
                OMAttribute attr = (OMAttribute)it.next();
                validateTarget._anyAttr.add(new GenericAttribute(attr.getLocalName(), attr.getAttributeValue()));
            }
        }
        if ((it = element.getChildElements()) != null) {
            while (it.hasNext()) {
                OMElement workEl = (OMElement)it.next();
                String localName = workEl.getLocalName();
                if ("SecurityTokenReference".equals(localName)) {
                    validateTarget.securityTokenReference = WSSecExtObjectBuilder.buildSecurityTokenReference(workEl);
                    continue;
                }
                if (new SAML1TokenImpl().isCompatibleElement(workEl)) {
                    validateTarget.securityToken = WSSecExtObjectBuilder.buildSignedSecurityToken(workEl);
                    continue;
                }
                validateTarget._anyElement.add(workEl.cloneOMElement());
            }
        }
        validateTarget.setParseSource(element);
        this.copyFrom(validateTarget);
        return this;
    }

    public WSTrust getWSTrust() {
        return this.wst;
    }
}

