/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.util.SOAPHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.GatekeeperFilter;
import org.eclipse.alf.security.sso.server.gatekeeper.GatekeeperRequestDispatcher;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperConfigLoader;
import org.eclipse.alf.security.sso.server.gatekeeper.filterloader.ALFSSOPrincipal;
import org.eclipse.alf.security.sso.server.gatekeeper.filterloader.PostAuthServletRequest;
import org.eclipse.alf.security.sso.server.gatekeeper.filterloader.PredispatchServletRequest;

public class GatekeeperFilterImpl
implements GatekeeperFilter,
Filter {
    private static final Logger log = Logger.getLogger(GatekeeperFilterImpl.class);
    public static final int REQUEST_TYPE_SOAP = 0;
    public static final int REQUEST_TYPE_BROWSER = 1;
    public static final int REQUEST_TYPE_UNKNOWN = 2;
    private FilterConfig filterConfig = null;
    private GatekeeperConfigLoader configLoader = null;

    public synchronized void init(FilterConfig filterConfig) throws ServletException {
        this.configLoader = new GatekeeperConfigLoader();
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain, ClassLoader originalContextClassLoader) throws IOException, ServletException {
        this.doFilter(request, response, chain, 2, originalContextClassLoader);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter(request, response, chain, 2, null);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain, int requestType, ClassLoader originalContextClassLoader) throws IOException, ServletException {
        if (!this.configLoader.isConfigurationLoaded()) {
            this.configLoader.loadConfiguration(this.filterConfig);
        }
        String newLine = System.getProperty("line.separator");
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        boolean inputStreamMarked = false;
        if (SOAPHelper.isSOAPRequestProfile((HttpServletRequest)req)) {
            if (!req.getInputStream().markSupported()) {
                req = new PredispatchServletRequest(req);
            }
            req.getInputStream().mark(Integer.MAX_VALUE);
            inputStreamMarked = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(newLine + "==========  Entering doFilter  =========="));
        }
        ALFSSOPrincipal localPrincipal = GatekeeperRequestDispatcher.dispatchRequest(req, resp, requestType);
        if (inputStreamMarked) {
            req.getInputStream().reset();
        }
        if (localPrincipal == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Authentication failed for HTTP request");
            }
            return;
        }
        String ssoToken = localPrincipal.getSSOToken();
        String subjectName = localPrincipal.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request successfully authenticated principal \"" + subjectName + "\""));
        }
        if (originalContextClassLoader != null) {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
        Object principal = null;
        if (ssoToken != null || subjectName != null) {
            principal = new ALFSSOPrincipal(ssoToken, subjectName);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Letting request through with NO ALF SSO princial object");
            }
            principal = req.getUserPrincipal();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(newLine + "==========  In doFilter before chain.doFilter  =========="));
        }
        chain.doFilter((ServletRequest)new PostAuthServletRequest(req, (Principal)principal), response);
        if (log.isDebugEnabled()) {
            log.debug((Object)(newLine + "==========  Leaving doFilter. After chain.doFilter  =========="));
        }
    }

    public void destroy() {
        log.info((Object)"Destroying gatekeeper");
    }
}

