/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.handler;

import java.text.MessageFormat;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.cookie.CookieData;
import org.eclipse.alf.security.sso.common.http.cookie.CookieHTTPHelper;
import org.eclipse.alf.security.sso.common.http.cookie.CookieManager;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.server.gatekeeper.GatekeeperHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.filterloader.ALFSSOPrincipal;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.HTTPRequestHandlerTokenExtractionHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.HTTPRequestHandlerWSFedRedirectHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.TokenExchangeHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.html.HTMLFactory;

public class HTTPRequestHandler {
    static final Logger log = Logger.getLogger(HTTPRequestHandler.class);
    private static final int TOKEN_SOURCE_NONE = 0;
    private static final int TOKEN_SOURCE_FEDERATION_PARAMS = 1;
    private static final int TOKEN_SOURCE_TOKEN_CACHE = 2;
    private static final int TOKEN_SOURCE_COOKIES = 3;
    private static final int TOKEN_SOURCE_HTTP_HEADERS = 4;

    public static ALFSSOPrincipal processHTTPRequest(HttpServletRequest req, HttpServletResponse resp, GatekeeperServiceConfig serviceConfig, WSFedData wsfData) throws ServletException, SSOException {
        String cookiePayload;
        boolean payloadTokenValidationSuccess;
        boolean logoutRequest;
        log.debug((Object)"Entering authenticate()");
        CoreConfig serviceCoreConfig = serviceConfig.getCoreConfig();
        SSOToken payloadToken = null;
        String errorMessage = null;
        int payloadSource = 0;
        boolean payloadValidated = false;
        boolean useTokensInHeaders = serviceCoreConfig.getBooleanParameter("UseTokensInHeaders", true);
        boolean useTokensInCookies = serviceCoreConfig.getBooleanParameter("UseTokensInCookies", true);
        boolean useTokensInTokenCache = GatekeeperConfig.getInstance().getTokenCache().getTokenCacheEnabled();
        if (wsfData != null) {
            try {
                payloadToken = HTTPRequestHandlerTokenExtractionHelper.extractSSOTokenFromWSFedSignInActionData(req, resp, serviceConfig, wsfData);
                payloadSource = 1;
            }
            catch (SSOException e) {
                String localizedMessage = GatekeeperHelper.getLocalizedMessage("gatekeeper.error.errorProcessingFedResponse", req.getLocale());
                HTMLFactory.setApplicationErrorResponse(req, resp, serviceCoreConfig, localizedMessage, e.getMessage());
                return null;
            }
        }
        if (useTokensInHeaders) {
            try {
                payloadToken = HTTPRequestHandlerTokenExtractionHelper.extractSSOTokenFromHTTPHeader(req, resp);
                if (payloadToken != null) {
                    payloadSource = 4;
                }
            }
            catch (SSOException e) {
                return null;
            }
        }
        if (useTokensInTokenCache) {
            try {
                payloadToken = HTTPRequestHandlerTokenExtractionHelper.extractSSOTokenFromTokenCache(req, resp, serviceConfig);
                if (payloadToken != null) {
                    payloadSource = 2;
                    payloadValidated = true;
                }
            }
            catch (SSOException e) {
                return null;
            }
        }
        if (useTokensInCookies && (!useTokensInTokenCache || payloadSource != 2 || payloadToken == null)) {
            try {
                payloadToken = HTTPRequestHandlerTokenExtractionHelper.extractSSOTokenFromCookies(req, resp, serviceConfig);
                if (payloadToken != null) {
                    payloadSource = 3;
                }
            }
            catch (SSOException e) {
                return null;
            }
        }
        if (payloadToken != null) {
            String tokenId = payloadToken.getId();
            if (GatekeeperConfig.getInstance().getTokenCache().getIsCanceled(tokenId)) {
                CookieManager cookieManager = serviceConfig.getCoreConfig().getCookieManager();
                CookieData cookieData = cookieManager.createCookieData(serviceConfig.getRpuri(), payloadToken, req.getRemoteAddr());
                ArrayList cookies = cookieManager.createCookie(cookieData);
                CookieHTTPHelper.deleteCookies((HttpServletResponse)resp, (ArrayList)cookies);
                GatekeeperConfig.getInstance().getTokenCache().removeToken(tokenId);
                payloadToken = null;
            }
        }
        boolean globalLogoutRequest = serviceConfig.matchesGlobalLogoutURI(req.getRequestURI(), req.getParameterMap());
        boolean localLogoutRequest = serviceConfig.matchesLocalLogoutURI(req.getRequestURI(), req.getParameterMap());
        boolean bl = logoutRequest = globalLogoutRequest || localLogoutRequest;
        if (payloadToken == null) {
            if (logoutRequest) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Logout request but no valid token found. Letting through with a (null) principal");
                }
                return new ALFSSOPrincipal();
            }
            HTTPRequestHandlerWSFedRedirectHelper.loginRedirect(req, resp, serviceConfig);
            return null;
        }
        if (logoutRequest) {
            CookieManager cookieManager = serviceConfig.getCoreConfig().getCookieManager();
            CookieData cookieData = cookieManager.createCookieData(serviceConfig.getRpuri(), payloadToken, req.getRemoteAddr());
            ArrayList cookies = cookieManager.createCookie(cookieData);
            CookieHTTPHelper.deleteCookies((HttpServletResponse)resp, (ArrayList)cookies);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Deleted token in cookies before logging out");
            }
            if (GatekeeperConfig.getInstance().getTokenCache().getTokenCacheEnabled()) {
                GatekeeperConfig.getInstance().getTokenCache().removeToken(payloadToken.getId());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Deleted token from token cache before logging out");
                }
            }
            if (globalLogoutRequest) {
                HTTPRequestHandlerWSFedRedirectHelper.logoutRedirect(req, resp, serviceConfig, payloadToken);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Global logout request: redirecting to logout screen");
                }
                return null;
            }
            if (localLogoutRequest) {
                return new ALFSSOPrincipal(null, payloadToken.getSubjectName());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Validating SSO token against token validation policy");
        }
        ExtendedResult validationResult = null;
        SAML1Policy tokenPolicy = serviceConfig.getBrowserTokenPolicy(payloadToken.getTokenType());
        if (!payloadValidated) {
            validationResult = payloadToken.validateToken((SSOTokenPolicy)tokenPolicy);
        }
        boolean bl2 = payloadTokenValidationSuccess = validationResult != null ? validationResult.isSuccess() : true;
        if (!payloadTokenValidationSuccess) {
            boolean validationFailureWaiver = false;
            if (payloadSource == 1) {
                errorMessage = "Validation of WS-Federation token failed with code " + validationResult.getCode() + ":" + payloadToken.toString();
                log.error((Object)errorMessage);
                String localizedMessage = GatekeeperHelper.getLocalizedMessage("gatekeeper.error.errorObtainingSecToken", req.getLocale());
                String localizedDetailedMessage = GatekeeperHelper.getLocalizedMessage("gatekeeper.error.tokenValidatonFailed", req.getLocale());
                localizedDetailedMessage = MessageFormat.format(localizedDetailedMessage, new Integer(validationResult.getCode()).toString());
                HTMLFactory.setApplicationErrorResponse(req, resp, serviceCoreConfig, localizedMessage, localizedDetailedMessage);
                return null;
            }
            if (validationResult.getCode() == 10) {
                boolean useFederationServerForRenew;
                log.info((Object)"Validating SSO token against token validation policy failed: token expired");
                if (GatekeeperConfig.getInstance().getTokenCache().getTokenCacheEnabled()) {
                    GatekeeperConfig.getInstance().getTokenCache().removeToken(payloadToken.getId());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Token expired: removing from token cache");
                    }
                }
                if (useFederationServerForRenew = serviceCoreConfig.getBooleanParameter("UseFederationServerForRenew", true)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Redirecting to login (always use federation services");
                    }
                    HTTPRequestHandlerWSFedRedirectHelper.loginRedirect(req, resp, serviceConfig);
                    return null;
                }
                try {
                    payloadToken = TokenExchangeHelper.getSSOTokenWithExpiredToken(payloadToken, serviceConfig.getRpuri().toString());
                }
                catch (SSOException e) {
                    errorMessage = "Error requesting security token from STS:" + e.getMessage();
                    log.error((Object)errorMessage, (Throwable)e);
                    log.debug((Object)"Redirecting to login");
                    HTTPRequestHandlerWSFedRedirectHelper.loginRedirect(req, resp, serviceConfig);
                    return null;
                }
                log.debug((Object)"Validating SSO token against token validation policy");
                tokenPolicy = serviceConfig.getBrowserTokenPolicy(payloadToken.getTokenType());
                validationResult = payloadToken.validateToken((SSOTokenPolicy)tokenPolicy);
                if (!validationResult.isSuccess()) {
                    errorMessage = "New ALF SSO token aquired successfully, but validation failed with code " + validationResult.getCode() + ":" + payloadToken.toString();
                    log.error((Object)errorMessage);
                    HTTPRequestHandlerWSFedRedirectHelper.loginRedirect(req, resp, serviceConfig);
                    return null;
                }
                validationFailureWaiver = true;
            }
            if (!validationFailureWaiver) {
                errorMessage = "Found ALF SSO token, but validation failed with code " + validationResult.getCode() + ":" + payloadToken.toString();
                log.error((Object)errorMessage);
                HTTPRequestHandlerWSFedRedirectHelper.loginRedirect(req, resp, serviceConfig);
                return null;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ALF SSO token validated OK: " + payloadToken.getSubjectName()));
        }
        if (payloadSource == 1) {
            CookieManager cookieManager = serviceConfig.getCoreConfig().getCookieManager();
            CookieData cookieData = cookieManager.createCookieData(serviceConfig.getRpuri(), payloadToken, req.getRemoteAddr());
            cookiePayload = cookieManager.getCookiePayloadAsB64(cookieData);
            String cookiePayloadChecksum = DigestUtils.shaHex((String)cookiePayload);
            ArrayList cookies = cookieManager.createCookie(cookieData, cookiePayload);
            CookieHTTPHelper.addCokiesToResponse((HttpServletResponse)resp, (ArrayList)cookies);
            if (GatekeeperConfig.getInstance().getTokenCache().getTokenCacheEnabled()) {
                GatekeeperConfig.getInstance().getTokenCache().add(payloadToken, cookiePayloadChecksum, req.getRemoteAddr());
            }
        }
        if (payloadSource == 3 && GatekeeperConfig.getInstance().getTokenCache().getTokenCacheEnabled()) {
            if (GatekeeperConfig.getInstance().getTokenCache().getTokenById(payloadToken.getId()) == null) {
                CookieManager cookieManager = serviceConfig.getCoreConfig().getCookieManager();
                CookieData cookieData = cookieManager.createCookieData(serviceConfig.getRpuri(), payloadToken, req.getRemoteAddr());
                cookiePayload = cookieManager.getCookiePayloadAsB64(cookieData);
                String checksum = DigestUtils.shaHex((String)cookiePayload);
                GatekeeperConfig.getInstance().getTokenCache().add(payloadToken, checksum, req.getRemoteAddr());
            } else {
                GatekeeperConfig.getInstance().getTokenCache().resetTokenCacheEntryTTL(payloadToken.getId());
            }
        }
        return new ALFSSOPrincipal(payloadToken.toString(), payloadToken.getSubjectName());
    }
}

