/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.html.impl;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.html.ErrorPageGenerator;

public class ErrorPageGeneratorImpl
implements ErrorPageGenerator {
    private static final Logger log = Logger.getLogger(ErrorPageGeneratorImpl.class);

    public void generateErrorPage(HttpServletRequest req, HttpServletResponse resp, CoreConfig conf, String errorMessage, String detailedErrorMessage) throws ServletException {
        log.info((Object)("Redirecting to application error page. error=\"" + errorMessage + "\", details=\"" + detailedErrorMessage + "\""));
        PrintWriter writer = null;
        try {
            writer = resp.getWriter();
        }
        catch (IOException e) {
            log.error((Object)"Cannot get response writer", (Throwable)e);
            throw new ServletException("Cannot get response writer", (Throwable)e);
        }
        String errorMessageHTMLLine = StringHelper.isBlank((String)errorMessage) ? "<H2>Unknown ALF SSO Gatekeeper error</H2>" : "<H2>ALF SSO Gatekeeper error has occured: " + errorMessage + "</H2>";
        String detailErrorMessageHTMLLine = StringHelper.isBlank((String)detailedErrorMessage) ? "" : "<p><b>Detail</b></p><p> " + detailedErrorMessage + "</p>";
        writer.println("<html>");
        writer.println("<head>");
        writer.println("<title>Error Page</title>");
        writer.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        writer.println("</head>");
        writer.println("<body bgcolor=\"#FFFFFF\">");
        writer.println(errorMessageHTMLLine);
        writer.println(detailErrorMessageHTMLLine);
        writer.println("</body>");
        writer.println("</html>");
    }
}

