/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.html.impl;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.html.WSFedRedirectPageGenerator;

public class WSFedRedirectPageGeneratorImpl
implements WSFedRedirectPageGenerator {
    private static final Logger log = Logger.getLogger(WSFedRedirectPageGeneratorImpl.class);

    public void genereateWSFedRedirectPage(HttpServletRequest req, HttpServletResponse resp, CoreConfig conf, String targetURL, WSFedData wsfData) throws ServletException {
        if (wsfData == null || wsfData.isEmpty() || StringHelper.isBlank((String)targetURL)) {
            log.error((Object)"Invalid arguments");
            throw new ServletException("Invalid WS-Federation parameters");
        }
        PrintWriter writer = null;
        try {
            writer = resp.getWriter();
        }
        catch (IOException e) {
            log.error((Object)"Cannot get response writer", (Throwable)e);
            throw new ServletException("Cannot get response writer", (Throwable)e);
        }
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
        writer.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">");
        writer.println("<head>");
        writer.println("<title>Redirecting to ALF SSO Federation Services</title>");
        writer.println("</head>");
        writer.println("<body onload=\"document.forms[0].submit()\">");
        writer.println("<script type=\"text/javascript\">");
        writer.println("document.write(\"<p>You are automatically being redirected to ALF SSO Federation services... </p>\");");
        writer.println("</script>");
        writer.println("<noscript>");
        writer.println("<p>");
        writer.println("<strong>Note:</strong> Since your browser does not support JavaScript, you must press the");
        writer.println("Continue button once to proceed to the requested site.");
        writer.println("</p>");
        writer.println("</noscript>");
        writer.println("<form id=\"postRedirect\" action=\"" + targetURL + "\" method=\"POST\">");
        writer.println("<div>");
        WSFedHelper.printHTMLFormInputs((WSFedData)wsfData, (PrintWriter)writer);
        writer.println("</div>");
        writer.println("<noscript>");
        writer.println("<div>");
        writer.println("<input type=\"submit\" value=\"Continue\" />");
        writer.println("</div>");
        writer.println("</noscript>");
        writer.println("</form>");
        writer.println("</body>");
        writer.println("</html>");
    }
}

