/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.SSOClaim;
import org.eclipse.alf.security.sso.common.token.SSOTokenPolicy;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SignedSecurityToken;

public interface SSOToken {
    public static final String TOKEN_UNKNOWN = "UNKNOWN";
    public static final String TOKEN_GENERIC = "http://www.eclipse.org/ALF/1.0/claims/TicketType";
    public static final String TOKEN_TGT = "http://www.eclipse.org/ALF/1.0/claims/TicketType#TGT";
    public static final String TOKEN_ST = "http://www.eclipse.org/ALF/1.0/claims/TicketType#ST";
    public static final String TOKEN_NATIVE_TYPE_SAML = "saml:SAML";
    public static final String TOKEN_NATIVE_TYPE_SAML_VERSION10 = "1.0";
    public static final String TOKEN_NATIVE_TYPE_SAML_VERSION11 = "1.1";
    public static final String TOKEN_NATIVE_TYPE_SAML_VERSION20 = "2.0";
    public static final String TOKEN_NATIVE_TYPE_USERNAMETOKEN = "wsse:UsernameToken";
    public static final String TOKEN_NATIVE_TYPE_USERNAMETOKEN_VERSION10 = "1.0";

    public String getTokenType();

    public String getNativeTokenType();

    public String getNativeTokenVersion();

    public QName getNativeTokenQName();

    public String getId();

    public String getIssuer();

    public String getSubjectName();

    public X509Certificate getSubjectX509Certificate() throws SSOException;

    public PublicKey getSubjectPublicKey() throws SSOException;

    public Date getIssueInstant();

    public Date getNotBefore();

    public Date getNotOnOrAfter();

    public String[] getTargetRelyingParties();

    public Object getNativeObject();

    public ExtendedResult validateToken();

    public ExtendedResult validateToken(SSOTokenPolicy var1);

    public void setValidationPolicy(SSOTokenPolicy var1);

    public SSOTokenPolicy getValidationPolicy();

    public boolean isExpired();

    public boolean compareTo(SSOToken var1);

    public String toString();

    public OMElement toOM() throws SSOException;

    public SignedSecurityToken toSecurityToken();

    public boolean isSSOTokenElement(OMElement var1);

    public Iterator getSSOClaims();

    public SSOClaim getSSOClaim(QName var1);
}

