/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy;

import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;

public class AudienceRestrictionPolicy
extends BasePolicy
implements Cloneable {
    private static final Logger log = Logger.getLogger(AudienceRestrictionPolicy.class);
    private static final boolean DEFAULT_ENFORCED = true;
    public static final String DEFAULT_RELYING_PARTY_URI = RPURI.getBase() + ":*:*:*";
    public static final boolean DEFAULT_RELYING_PARTY_FROM_CTX = true;
    public static final boolean DEFAULT_MATCH_TYPE = false;
    public static final boolean DEFAULT_MATCH_REALM = false;
    public static final boolean DEFAULT_MATCH_INSTANCE = false;
    public static final boolean DEFAULT_ALLOW_ANONYMOUS_TYPE = true;
    public static final boolean DEFAULT_ALLOW_ANONYMOUS_REALM = true;
    public static final boolean DEFAULT_ALLOW_ANONYMOUS_INSTANCE = true;
    protected String relyingPartyURI;
    protected boolean relyingPartyURI_inheritFromContext;
    protected boolean allowUnconformingRPURIs;
    protected boolean matchType;
    protected boolean matchRealm;
    protected boolean matchInstance;
    protected boolean allowAnonymousType;
    protected boolean allowAnonymousRealm;
    protected boolean allowAnonymousInstance;

    public AudienceRestrictionPolicy() {
    }

    public AudienceRestrictionPolicy(SAML1Policy contextPolicy) {
        super(contextPolicy);
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public AudienceRestrictionPolicy(AudienceRestrictionPolicy other) {
        super(other);
        this.relyingPartyURI = other.relyingPartyURI;
        this.relyingPartyURI_inheritFromContext = other.relyingPartyURI_inheritFromContext;
        this.allowUnconformingRPURIs = other.allowUnconformingRPURIs;
        this.matchType = other.matchType;
        this.matchRealm = other.matchRealm;
        this.matchInstance = other.matchInstance;
        this.allowAnonymousType = other.allowAnonymousType;
        this.allowAnonymousRealm = other.allowAnonymousRealm;
        this.allowAnonymousInstance = other.allowAnonymousInstance;
    }

    public void reset() {
        this.relyingPartyURI = DEFAULT_RELYING_PARTY_URI;
        this.relyingPartyURI_inheritFromContext = true;
        this.matchType = false;
        this.matchRealm = false;
        this.matchInstance = false;
        this.allowAnonymousType = true;
        this.allowAnonymousRealm = true;
        this.allowAnonymousInstance = true;
    }

    public static boolean getIsEnforcedByDefault() {
        return true;
    }

    public String getRelyingPartyURI() {
        if (this.getInheritRPFromContext() && this.contextPolicy != null) {
            return this.contextPolicy.getRelyingPartyURI();
        }
        return this.relyingPartyURI;
    }

    public void setRelyingPartyURI(String relyingPartyURI) {
        this.relyingPartyURI = relyingPartyURI;
    }

    public boolean getInheritRPFromContext() {
        return this.relyingPartyURI_inheritFromContext;
    }

    public void setInheritRPFromContext(boolean inheritRPFromContext) {
        this.relyingPartyURI_inheritFromContext = inheritRPFromContext;
    }

    public boolean getAllowUnconformingRPURIs() {
        return this.allowUnconformingRPURIs;
    }

    public void setAllowUnconformingRPURIs(boolean allowUnconformingRPURIs) {
        this.allowUnconformingRPURIs = allowUnconformingRPURIs;
    }

    public boolean getMatchType() {
        return this.matchType;
    }

    public void setMatchType(boolean matchType) {
        this.matchType = matchType;
    }

    public boolean getMatchRealm() {
        return this.matchRealm;
    }

    public void setMatchRealm(boolean matchRealm) {
        this.matchRealm = matchRealm;
    }

    public boolean getMatchInstance() {
        return this.matchInstance;
    }

    public void setMatchInstance(boolean matchInstance) {
        this.matchInstance = matchInstance;
    }

    public boolean getAllowAnonymousType() {
        return this.allowAnonymousType;
    }

    public void setAllowAnonymousType(boolean allowAnonymousType) {
        this.allowAnonymousType = allowAnonymousType;
    }

    public boolean getAllowAnonymousRealm() {
        return this.allowAnonymousRealm;
    }

    public void setAllowAnonymousRealm(boolean allowAnonymousRealm) {
        this.allowAnonymousRealm = allowAnonymousRealm;
    }

    public boolean getAllowAnonymousInstance() {
        return this.allowAnonymousInstance;
    }

    public void setAllowAnonymousInstance(boolean allowAnonymousInstance) {
        this.allowAnonymousInstance = allowAnonymousInstance;
    }

    public Object clone() {
        return new AudienceRestrictionPolicy(this);
    }
}

