/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.builder;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.saml.policy.AuthorityBindingPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.BasePolicyBuilder;
import org.eclipse.alf.security.sso.common.util.SSOHelper;

public class AuthorityBindingPolicyBuilder
extends BasePolicyBuilder {
    private static final Logger log = Logger.getLogger(AuthorityBindingPolicyBuilder.class);
    public static final String AUTHORITY_BINDING_POLICY_LN = "AuthorityBindingPolicy";

    public String getLocalName() {
        return AUTHORITY_BINDING_POLICY_LN;
    }

    public BasePolicy build(OMElement element) throws SSOException {
        return this.build(element, null);
    }

    public BasePolicy build(OMElement element, BasePolicy basePolicy) throws SSOException {
        if (element == null) {
            log.warn((Object)"AuthorityBindingPolicyBuilder.build(null) called");
            return basePolicy;
        }
        OMElement el = element.getFirstChildWithName(new QName(this.getLocalName()));
        if (el == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"AuthorityBindingPolicyBuilder.build(): policy local name not found");
            }
            return basePolicy;
        }
        AuthorityBindingPolicy authorityBindingPolicy = null;
        authorityBindingPolicy = basePolicy != null ? (AuthorityBindingPolicy)basePolicy.clone() : new AuthorityBindingPolicy();
        if (SSOHelper.toBoolean(this.getAttribute(el, "override"), authorityBindingPolicy.getOverride())) {
            log.debug((Object)"AuthorityBindingPolicyBuilder.build(): Overriding previously defined policy");
            authorityBindingPolicy = new AuthorityBindingPolicy();
        }
        authorityBindingPolicy.setEnforced(SSOHelper.toBoolean(this.getAttribute(el, "enforce"), authorityBindingPolicy.getEnforced()));
        return authorityBindingPolicy;
    }
}

