/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.util;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;

public class SOAPFaultFactory {
    private static Logger log = Logger.getLogger(SOAPFaultFactory.class);

    public static SOAPEnvelope generateSOAPFault(SOAPEnvelope soapEnvelope, ExtendedResult validationResult, String faultActor) {
        if (soapEnvelope == null) {
            return SOAPFaultFactory.generateSOAP11Fault(validationResult, faultActor);
        }
        String ns = soapEnvelope.getNamespace().getNamespaceURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(ns)) {
            return SOAPFaultFactory.generateSOAP11Fault(validationResult, faultActor);
        }
        return SOAPFaultFactory.generateSOAP12Fault(validationResult, faultActor);
    }

    protected static SOAPEnvelope generateSOAP11Fault(ExtendedResult validationResult, String faultActor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating SOAP fault for faultActor=" + faultActor));
        }
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        SOAPFault fault = soapFactory.createSOAPFault(envelope.getBody());
        SOAPFaultCode code = soapFactory.createSOAPFaultCode(fault);
        String codeValueString1 = envelope.getNamespace().getPrefix() + ":" + "Client";
        String codeValueString2 = "wsse:FailedAuthentication";
        code.setText(codeValueString1 + "." + codeValueString2);
        if (faultActor != null) {
            SOAPFaultRole faultRole = soapFactory.createSOAPFaultRole(fault);
            faultRole.setText(faultActor);
        }
        SOAPFaultReason faultReason = soapFactory.createSOAPFaultReason(fault);
        if (validationResult == null) {
            faultReason.setText("No compatible tokens found on the request");
        } else {
            String reason = "Validation failed. Error code: " + validationResult.getCode();
            if (validationResult.getMessage() != null) {
                reason = reason + " Error message: " + validationResult.getMessage();
            }
            faultReason.setText(reason);
        }
        SOAPFaultDetail faultDetail = soapFactory.createSOAPFaultDetail(fault);
        if (validationResult == null) {
            faultDetail.setText("No compatible tokens found on the request");
        } else {
            String reason = "Validation failed. Error code: " + validationResult.getCode();
            if (validationResult.getMessage() != null) {
                reason = reason + " Error message: " + validationResult.getMessage();
            }
            faultReason.setText(reason);
        }
        return envelope;
    }

    protected static SOAPEnvelope generateSOAP12Fault(ExtendedResult validationResult, String faultActor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating SOAP fault for faultActor=" + faultActor));
        }
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP12Factory();
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        SOAPFault fault = soapFactory.createSOAPFault(envelope.getBody());
        SOAPFaultCode code = soapFactory.createSOAPFaultCode(fault);
        SOAPFaultValue value = soapFactory.createSOAPFaultValue(code);
        value.setText(envelope.getNamespace().getPrefix() + ":" + "Sender");
        code.setValue(value);
        SOAPFaultSubCode subcode1 = soapFactory.createSOAPFaultSubCode(code);
        SOAPFaultValue subvalue1 = soapFactory.createSOAPFaultValue(subcode1);
        subvalue1.setText("wsse:FailedAuthentication");
        if (faultActor != null) {
            SOAPFaultRole faultRole = soapFactory.createSOAPFaultRole(fault);
            faultRole.setText(faultActor);
        }
        SOAPFaultReason faultReason = soapFactory.createSOAPFaultReason(fault);
        if (validationResult == null) {
            faultReason.setText("No security tokens found on the request");
        } else {
            String reason = "Validation failed. Error code: " + validationResult.getCode();
            if (validationResult.getMessage() != null) {
                reason = reason + " Error message: " + validationResult.getMessage();
            }
            faultReason.setText(reason);
        }
        SOAPFaultDetail faultDetail = soapFactory.createSOAPFaultDetail(fault);
        if (validationResult == null) {
            faultDetail.setText("No compatible tokens found on the request");
        } else {
            String detailText = "Validation failed. Error code: " + validationResult.getCode();
            if (validationResult.getMessage() != null) {
                detailText = detailText + " Error message: " + validationResult.getMessage();
            }
            faultDetail.setText(detailText);
        }
        return envelope;
    }

    public static SOAPEnvelope generateSOAP11AuthenticationFailedFault(String reason, String detail) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Generating SOAP 1.1 fault");
        }
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        SOAPFault fault = soapFactory.createSOAPFault(envelope.getBody());
        SOAPFaultCode code = soapFactory.createSOAPFaultCode(fault);
        String codeValueString1 = envelope.getNamespace().getPrefix() + ":" + "Client";
        String codeValueString2 = "wsse:FailedAuthentication";
        code.setText(codeValueString1 + "." + codeValueString2);
        if (reason != null) {
            SOAPFaultReason faultReason = soapFactory.createSOAPFaultReason(fault);
            faultReason.setText(reason);
        }
        if (detail == null) {
            SOAPFaultDetail faultDetail = soapFactory.createSOAPFaultDetail(fault);
            faultDetail.setText(detail);
        }
        return envelope;
    }

    public static void returnSOAPFault(HttpServletResponse resp, SOAPEnvelope fault) throws ServletException {
        if (fault == null) {
            return;
        }
        PrintWriter writer = null;
        try {
            writer = resp.getWriter();
        }
        catch (IOException e) {
            log.error((Object)"Cannot get response writer to return the SOAPFault", (Throwable)e);
            throw new ServletException("Cannot get response writer to return the SOAPFault", (Throwable)e);
        }
        writer.println(fault.toString());
    }
}

